/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.shader;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.client.shader.PresentShaderHandle;
import com.mushroom.midnight.client.shader.ShaderHandle;
import com.mushroom.midnight.client.shader.VoidShaderHandle;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.shader.ShaderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import org.lwjgl.opengl.GL11;

public class WorldShader
implements ISelectiveResourceReloadListener {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private final ResourceLocation location;
    private final Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
    private ShaderManager manager;
    private boolean initialized;

    public WorldShader(ResourceLocation location) {
        this.location = location;
        ((IReloadableResourceManager)MC.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.SHADERS)) {
            if (this.manager != null) {
                this.manager.func_147988_a();
            }
            for (ResourceLocation texture : this.textures.values()) {
                this.prepareTexture(texture);
            }
            this.initialized = false;
        }
    }

    public WorldShader withTextureSampler(String key, ResourceLocation texture) {
        this.prepareTexture(texture);
        this.textures.put(key, texture);
        return this;
    }

    private void prepareTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
    }

    public ShaderHandle use(Consumer<ShaderHandle> setup) {
        ShaderHandle handle = this.makeHandle();
        setup.accept(handle);
        handle.get("FogMode").func_148083_a(GL11.glGetInteger((int)2917), 0, 0, 0);
        handle.use();
        return handle;
    }

    private ShaderHandle makeHandle() {
        ShaderManager manager = this.get();
        if (manager != null) {
            return new PresentShaderHandle(manager);
        }
        return new VoidShaderHandle();
    }

    private ShaderManager get() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.initialized) {
            return;
        }
        try {
            Minecraft mc = Minecraft.func_71410_x();
            this.manager = new ShaderManager(mc.func_110442_L(), this.location.toString());
            for (Map.Entry<String, ResourceLocation> entry : this.textures.entrySet()) {
                ITextureObject texture = mc.func_110434_K().func_110581_b(entry.getValue());
                this.manager.func_147992_a(entry.getKey(), (Object)texture);
            }
        }
        catch (IOException e) {
            Midnight.LOGGER.error("Failed to load shader {}", (Object)this.location, (Object)e);
        }
        finally {
            this.initialized = true;
        }
    }

    public boolean isAvailable() {
        if (!OpenGlHelper.field_148824_g) {
            return false;
        }
        return !this.initialized || this.manager != null;
    }
}

