/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.particle;

import com.mushroom.midnight.client.particle.MidnightParticles;
import com.mushroom.midnight.client.particle.ParticleSystem;
import com.mushroom.midnight.client.particle.RiftParticle;
import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.helper.Helper;
import java.util.Random;
import javax.vecmath.Vector2f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.util.math.MathHelper;

public class RiftParticleSystem
implements ParticleSystem<EntityRift> {
    private static final int ORBITAL_RING_COUNT = 3;
    private static final int ORBITAL_PARTICLE_COUNT = 240;
    private final EntityRift rift;
    private Ring[] particleRings;
    private int releasedParticleCount;

    public RiftParticleSystem(EntityRift rift) {
        this.rift = rift;
    }

    @Override
    public void updateParticles(Random random) {
        if (!this.rift.isBridgeValid()) {
            return;
        }
        if (!Helper.isMidnightDimension(this.rift.field_70170_p) && random.nextInt(10) == 0) {
            this.spawnSpore(this.rift, random, 3.0f);
        }
        if (this.rift.isOpen()) {
            this.updateRings(random);
            if (!this.rift.isUnstable()) {
                this.spawnOrbitalParticles(this.rift, random);
            }
        } else if (this.rift.getBridge().open.getTimer() == 2) {
            int sporeCount = random.nextInt(3) + 8;
            for (int i = 0; i < sporeCount; ++i) {
                this.spawnSpore(this.rift, random, 1.0f);
            }
        }
    }

    @Override
    public EntityRift getEntity() {
        return this.rift;
    }

    private void spawnSpore(EntityRift rift, Random random, float displacementScale) {
        double velocityX = random.nextGaussian() * (double)0.3f;
        double velocityY = random.nextGaussian() * (double)0.3f;
        double velocityZ = random.nextGaussian() * (double)0.3f;
        double particleX = rift.field_70165_t + velocityX * (double)displacementScale;
        double particleY = rift.field_70163_u + (double)(rift.field_70131_O / 2.0f) + velocityY * (double)displacementScale;
        double particleZ = rift.field_70161_v + velocityZ * (double)displacementScale;
        MidnightParticles.AMBIENT_SPORE.spawn(rift.field_70170_p, particleX, particleY, particleZ, velocityX, velocityY, velocityZ, new int[0]);
    }

    private void updateRings(Random random) {
        if (this.particleRings == null) {
            this.particleRings = this.generateOrbitalRings(random);
        }
        for (Ring ring : this.particleRings) {
            ring.update();
        }
    }

    private Ring[] generateOrbitalRings(Random random) {
        Ring[] rings = new Ring[3];
        for (int i = 0; i < rings.length; ++i) {
            float tiltX = random.nextFloat() * 360.0f;
            float tiltZ = random.nextFloat() * 360.0f;
            Vector2f tiltSpeed = new Vector2f(random.nextFloat(), random.nextFloat());
            tiltSpeed.normalize();
            rings[i] = new Ring(tiltX, tiltZ, tiltSpeed.x * 0.05f, tiltSpeed.y * 0.05f);
        }
        return rings;
    }

    private void spawnOrbitalParticles(EntityRift rift, Random random) {
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        int count = Math.min(random.nextInt(2) + 1, 240 - this.releasedParticleCount);
        for (int i = 0; i < count; ++i) {
            float offsetHorizontal = (random.nextFloat() - 0.5f) * rift.field_70130_N * 0.8f;
            float offsetVertical = (random.nextFloat() - 0.5f) * rift.field_70131_O * 0.8f;
            float theta = (float)Math.toRadians(rift.field_70177_z);
            double particleX = rift.field_70165_t + (double)(MathHelper.func_76134_b((float)theta) * offsetHorizontal);
            double particleY = rift.field_70163_u + (double)(rift.field_70131_O / 2.0f) + (double)offsetVertical;
            double particleZ = rift.field_70161_v + (double)(MathHelper.func_76126_a((float)theta) * offsetHorizontal);
            Ring ring = this.particleRings[random.nextInt(this.particleRings.length)];
            float radius = random.nextFloat() + 2.5f;
            float angleOffset = random.nextFloat() * 360.0f;
            float verticalOffset = (random.nextFloat() - 0.5f) * 0.25f;
            float rotateSpeed = random.nextFloat() * 0.5f + 1.25f;
            RiftParticle particle = new RiftParticle(this, ring, particleX, particleY, particleZ, radius, angleOffset, verticalOffset, rotateSpeed);
            effectRenderer.func_78873_a((Particle)particle);
            ++this.releasedParticleCount;
        }
    }

    public void returnParticle() {
        --this.releasedParticleCount;
    }

    public static class Ring {
        private float tiltX;
        private float tiltZ;
        private float tiltSpeedX;
        private float tiltSpeedZ;

        public Ring(float tiltX, float tiltZ, float tiltSpeedX, float tiltSpeedZ) {
            this.tiltX = tiltX;
            this.tiltZ = tiltZ;
            this.tiltSpeedX = tiltSpeedX;
            this.tiltSpeedZ = tiltSpeedZ;
        }

        public void update() {
            this.tiltX += this.tiltSpeedX;
            this.tiltZ += this.tiltSpeedZ;
        }

        public float getTiltX() {
            return this.tiltX;
        }

        public float getTiltZ() {
            return this.tiltZ;
        }
    }
}

