/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client;

import com.mushroom.midnight.client.FluidImmersionRenderer;
import com.mushroom.midnight.client.particle.MidnightParticles;
import com.mushroom.midnight.client.sound.IdleRiftSound;
import com.mushroom.midnight.common.capability.RifterCapturable;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.registry.ModEffects;
import com.mushroom.midnight.common.registry.ModSounds;
import com.mushroom.midnight.common.registry.ModSurfaceBiomes;
import com.mushroom.midnight.common.util.EntityUtil;
import com.mushroom.midnight.common.util.ResetHookHandler;
import com.mushroom.midnight.common.world.GlobalBridgeManager;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="midnight", value={Side.CLIENT})
public class ClientEventHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final float HOOK_SENSITIVITY = 0.2f;
    private static final ResetHookHandler<Float> SENSITIVITY_HOOK = new ResetHookHandler<Float>(Float.valueOf(0.2f)).getValue(() -> Float.valueOf(ClientEventHandler.MC.field_71474_y.field_74341_c)).setValue(sensitivity -> {
        ClientEventHandler.MC.field_71474_y.field_74341_c = sensitivity.floatValue();
    });
    private static final long AMBIENT_SOUND_INTERVAL = 140L;
    private static final int AMBIENT_SOUND_CHANCE = 120;
    private static long lastAmbientSoundTime;
    private static ISound playingMusic;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (!MC.func_147113_T()) {
            EntityPlayerSP player = ClientEventHandler.MC.field_71439_g;
            if (player == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.END) {
                if (playingMusic != null && !MC.func_147118_V().func_147692_c(playingMusic)) {
                    playingMusic = null;
                }
                if (Helper.isMidnightDimension(player.field_70170_p)) {
                    ClientEventHandler.spawnAmbientParticles((EntityPlayer)player);
                    ClientEventHandler.playAmbientSounds((EntityPlayer)player);
                } else {
                    ClientEventHandler.pullSelfPlayer(player);
                }
                SENSITIVITY_HOOK.apply(player.func_70644_a(ModEffects.STUNNED));
            } else if (event.phase == TickEvent.Phase.START) {
                GlobalBridgeManager.getClient().update();
            }
        }
    }

    private static void pullSelfPlayer(EntityPlayerSP player) {
        AxisAlignedBB pullBounds = player.func_174813_aQ().func_186662_g(8.0);
        List rifts = player.field_70170_p.func_72872_a(EntityRift.class, pullBounds);
        for (EntityRift rift : rifts) {
            if (rift.wasUsed()) continue;
            double pullIntensity = rift.getPullIntensity();
            if (pullIntensity > 0.0 && player.func_70608_bn()) {
                ClientEventHandler.cancelSleep(player);
            }
            rift.pullEntity(pullIntensity, (Entity)player);
        }
    }

    private static void cancelSleep(EntityPlayerSP player) {
        NetHandlerPlayClient handler = player.field_71174_a;
        handler.func_147297_a((Packet)new CPacketEntityAction((Entity)player, CPacketEntityAction.Action.STOP_SLEEPING));
    }

    private static void playAmbientSounds(EntityPlayer player) {
        Random rand = player.field_70170_p.field_73012_v;
        long worldTime = player.field_70170_p.func_82737_E();
        if (worldTime - lastAmbientSoundTime > 140L && rand.nextInt(120) == 0) {
            ResourceLocation ambientSound = ModSounds.AMBIENT.func_187503_a();
            float volume = rand.nextFloat() * 0.4f + 0.8f;
            float pitch = rand.nextFloat() * 0.6f + 0.7f;
            float x = (float)(player.field_70165_t + (double)rand.nextFloat() - 0.5);
            float y = (float)(player.field_70163_u + (double)rand.nextFloat() - 0.5);
            float z = (float)(player.field_70161_v + (double)rand.nextFloat() - 0.5);
            PositionedSoundRecord sound = new PositionedSoundRecord(ambientSound, SoundCategory.AMBIENT, volume, pitch, false, 0, ISound.AttenuationType.NONE, x, y, z);
            MC.func_147118_V().func_147682_a((ISound)sound);
            lastAmbientSoundTime = worldTime;
        }
    }

    @SubscribeEvent
    public static void onSetupFogDensity(EntityViewRenderEvent.FogDensity event) {
        EntityLivingBase entity;
        if (FluidImmersionRenderer.immersedState.func_185914_p()) {
            return;
        }
        EntityLivingBase entityLivingBase = entity = event.getEntity() instanceof EntityLivingBase ? (EntityLivingBase)event.getEntity() : null;
        if (entity != null) {
            if (entity.func_70644_a(MobEffects.field_76440_q)) {
                return;
            }
            if (entity.func_70644_a(ModEffects.DARKNESS)) {
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                event.setCanceled(true);
                event.setDensity(0.15f);
                return;
            }
        }
        if (Helper.isMidnightDimension(event.getEntity().field_70170_p)) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            event.setCanceled(true);
            event.setDensity(0.015f);
        } else if (entity != null && entity.func_70644_a(ModEffects.STUNNED)) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            event.setCanceled(true);
            event.setDensity(0.15f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSetupFogColor(EntityViewRenderEvent.FogColors event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            if (entity.func_70644_a(ModEffects.STUNNED)) {
                event.setRed(0.1f);
                event.setGreen(0.1f);
                event.setBlue(0.1f);
            } else if (entity.func_70644_a(ModEffects.DARKNESS)) {
                event.setRed(0.0f);
                event.setGreen(0.0f);
                event.setBlue(0.0f);
            }
        }
    }

    private static void spawnAmbientParticles(EntityPlayer player) {
        Random random = player.field_70170_p.field_73012_v;
        double originX = player.field_70165_t;
        double originY = player.field_70163_u;
        double originZ = player.field_70161_v;
        for (int i = 0; i < 6; ++i) {
            double particleX = originX + (double)(random.nextInt(24) - random.nextInt(24));
            double particleY = originY + (double)(random.nextInt(24) - random.nextInt(24));
            double particleZ = originZ + (double)(random.nextInt(24) - random.nextInt(24));
            double velocityX = (random.nextDouble() - 0.5) * 0.04;
            double velocityY = (random.nextDouble() - 0.5) * 0.04;
            double velocityZ = (random.nextDouble() - 0.5) * 0.04;
            MidnightParticles.AMBIENT_SPORE.spawn(player.field_70170_p, particleX, particleY, particleZ, velocityX, velocityY, velocityZ, new int[0]);
        }
    }

    public static void onApplyRotations(EntityLivingBase entity) {
        boolean captured = RifterCapturable.isCaptured((Entity)entity);
        if (captured) {
            entity.field_184619_aG = 0.0f;
            entity.field_184618_aE = 0.0f;
            entity.field_70721_aZ = 0.0f;
            EntityUtil.Stance stance = EntityUtil.getStance(entity);
            if (stance == EntityUtil.Stance.QUADRUPEDAL) {
                GlStateManager.func_179109_b((float)0.0f, (float)entity.field_70131_O, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)(entity.field_70130_N / 2.0f), (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(entity.field_70131_O / 2.0f));
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent event) {
        if (!ClientEventHandler.isMusicSound()) {
            return;
        }
        if (ClientEventHandler.MC.field_71439_g != null && Helper.isMidnightDimension(ClientEventHandler.MC.field_71439_g.field_70170_p)) {
            SoundEvent sound = ClientEventHandler.getMusicSound((EntityPlayer)ClientEventHandler.MC.field_71439_g);
            if (sound == null || playingMusic != null) {
                event.setResultSound(null);
                return;
            }
            playingMusic = PositionedSoundRecord.func_184370_a((SoundEvent)sound);
            event.setResultSound(playingMusic);
        }
    }

    @SubscribeEvent
    public static void onSpawnEntity(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityRift && event.getWorld().field_72995_K) {
            MC.func_147118_V().func_147682_a((ISound)new IdleRiftSound((EntityRift)entity));
        }
    }

    @Nullable
    private static SoundEvent getMusicSound(EntityPlayer player) {
        Biome biome = player.field_70170_p.func_180494_b(player.func_180425_c());
        if (biome == ModSurfaceBiomes.CRYSTAL_SPIRES) {
            return ModSounds.MUSIC_CRYSTAL;
        }
        return ModSounds.MUSIC_GENERIC;
    }

    private static boolean isMusicSound() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return Arrays.stream(stackTrace).anyMatch(e -> e.getClassName().equals(MusicTicker.class.getName()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderVignetteOverLay(RenderGameOverlayEvent.Pre event) {
        if (MidnightConfig.client.hideVignetteEffect && event.getType() == RenderGameOverlayEvent.ElementType.VIGNETTE && Helper.isMidnightDimension((World)ClientEventHandler.MC.field_71441_e)) {
            WorldBorder worldborder = ClientEventHandler.MC.field_71441_e.func_175723_af();
            float distWarn = Math.max((float)worldborder.func_177748_q(), (float)Math.min(worldborder.func_177749_o() * (double)worldborder.func_177740_p() * 1000.0, Math.abs(worldborder.func_177751_j() - worldborder.func_177741_h())));
            if (worldborder.func_177745_a((Entity)ClientEventHandler.MC.field_71439_g) >= (double)distWarn) {
                event.setCanceled(true);
            }
        }
    }
}

