/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.gui;

import biomesoplenty.client.gui.GuiBOPPageList;
import biomesoplenty.client.gui.GuiEnumButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiListButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Mouse;

public class GuiBOPPageTable
extends GuiBOPPageList {
    private final List<GuiBOPPageList.GuiRowEntry> allRows = new ArrayList<GuiBOPPageList.GuiRowEntry>();
    private final Map<Integer, Gui> fieldIdToGuiMap = new HashMap<Integer, Gui>();
    private final List<GuiTextField> allTextFieldGuis = new ArrayList<GuiTextField>();
    private final GuiBOPPageList.GuiFieldEntry[] fields;
    private GuiBOPPageList.GuiResponder responder;
    private Gui focusedGui;

    public GuiBOPPageTable(int width, int height, int top, int bottom, int slotHeight, int pageNumber, GuiBOPPageList.GuiResponder responder, GuiBOPPageList.GuiFieldEntry ... fields) {
        super(width, height, top, bottom, slotHeight, pageNumber);
        this.responder = responder;
        this.fields = fields;
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (isVisible) {
            for (GuiBOPPageList.GuiFieldEntry field : this.fields) {
                if (field == null) continue;
                Gui gui = this.fieldIdToGuiMap.get(field.getFieldId());
                this.setVisible(gui, true);
            }
        } else {
            for (GuiBOPPageList.GuiFieldEntry field : this.fields) {
                if (field == null) continue;
                Gui gui = this.fieldIdToGuiMap.get(field.getFieldId());
                this.setVisible(gui, false);
            }
        }
    }

    private void setVisible(Gui gui, boolean isVisible) {
        if (gui instanceof GuiButton) {
            ((GuiButton)gui).field_146125_m = isVisible;
        } else if (gui instanceof GuiTextField) {
            ((GuiTextField)gui).func_146189_e(isVisible);
        } else if (gui instanceof GuiLabel) {
            ((GuiLabel)gui).field_146172_j = isVisible;
        }
    }

    @Override
    public void setup() {
        for (int k = 0; k < this.fields.length; k += 2) {
            GuiBOPPageList.GuiFieldEntry fieldLeft = this.fields[k];
            GuiBOPPageList.GuiFieldEntry fieldRight = k < this.fields.length - 1 ? this.fields[k + 1] : null;
            Gui guiLeft = this.createGui(fieldLeft, 0, fieldRight == null);
            Gui guiRight = this.createGui(fieldRight, 160, fieldLeft == null);
            GuiBOPPageList.GuiRowEntry row = new GuiBOPPageList.GuiRowEntry(guiLeft, guiRight);
            this.allRows.add(row);
            if (fieldLeft != null && guiLeft != null) {
                this.fieldIdToGuiMap.put(fieldLeft.getFieldId(), guiLeft);
                if (guiLeft instanceof GuiTextField) {
                    this.allTextFieldGuis.add((GuiTextField)guiLeft);
                }
            }
            if (fieldRight == null || guiRight == null) continue;
            this.fieldIdToGuiMap.put(fieldRight.getFieldId(), guiRight);
            if (!(guiRight instanceof GuiTextField)) continue;
            this.allTextFieldGuis.add((GuiTextField)guiRight);
        }
        this.resetRows();
    }

    private void resetRows() {
        this.allRows.clear();
        for (int i = 0; i < this.fields.length; i += 2) {
            GuiBOPPageList.GuiFieldEntry guilistentryLeft = this.fields[i];
            GuiBOPPageList.GuiFieldEntry guilistentryRight = i < this.fields.length - 1 ? this.fields[i + 1] : null;
            Gui guiLeft = this.fieldIdToGuiMap.get(guilistentryLeft.getFieldId());
            Gui guiRight = guilistentryRight != null ? this.fieldIdToGuiMap.get(guilistentryRight.getFieldId()) : null;
            GuiBOPPageList.GuiRowEntry guientry = new GuiBOPPageList.GuiRowEntry(guiLeft, guiRight);
            this.allRows.add(guientry);
        }
    }

    @Override
    public Gui getFocusedGuiElement() {
        return this.focusedGui;
    }

    @Override
    public Gui getGui(int fieldId) {
        return this.fieldIdToGuiMap.get(fieldId);
    }

    private Gui createGui(GuiBOPPageList.GuiFieldEntry field, int xOffset, boolean hasNoNeighbor) {
        if (field instanceof GuiBOPPageList.GuiSlideEntry) {
            return this.createSlider(this.field_148155_a / 2 - 155 + xOffset, 0, (GuiBOPPageList.GuiSlideEntry)field);
        }
        if (field instanceof GuiBOPPageList.GuiButtonEntry) {
            return this.createListButton(this.field_148155_a / 2 - 155 + xOffset, 0, (GuiBOPPageList.GuiButtonEntry)field);
        }
        if (field instanceof GuiBOPPageList.EditBoxEntry) {
            return this.createTextField(this.field_148155_a / 2 - 155 + xOffset, 0, (GuiBOPPageList.EditBoxEntry)field);
        }
        if (field instanceof GuiBOPPageList.GuiLabelEntry) {
            return this.createLabel(this.field_148155_a / 2 - 155 + xOffset, 0, (GuiBOPPageList.GuiLabelEntry)field, hasNoNeighbor);
        }
        if (field instanceof GuiBOPPageList.GuiEnumButtonEntry) {
            return this.createEnumButton(this.field_148155_a / 2 - 155 + xOffset, 0, (GuiBOPPageList.GuiEnumButtonEntry)field);
        }
        return null;
    }

    private GuiSlider createSlider(int xPosition, int yPosition, GuiBOPPageList.GuiSlideEntry field) {
        GuiSlider guislider = new GuiSlider((GuiPageButtonList.GuiResponder)this.responder, field.getFieldId(), xPosition, yPosition, field.getLabelText(), field.getMin(), field.getMax(), field.getValue(), field.getFormatHelper());
        guislider.field_146125_m = field.isVisible();
        return guislider;
    }

    private GuiListButton createListButton(int xPosition, int yPosition, GuiBOPPageList.GuiButtonEntry field) {
        GuiListButton guilistbutton = new GuiListButton((GuiPageButtonList.GuiResponder)this.responder, field.getFieldId(), xPosition, yPosition, field.getLabelText(), field.getValue());
        guilistbutton.field_146125_m = field.isVisible();
        return guilistbutton;
    }

    private GuiEnumButton createEnumButton(int xPosition, int yPosition, GuiBOPPageList.GuiEnumButtonEntry field) {
        GuiEnumButton guienumbutton = new GuiEnumButton(this.responder, field.getFieldId(), xPosition, yPosition, field.getLabelText(), field.getValue());
        guienumbutton.field_146125_m = field.isVisible();
        return guienumbutton;
    }

    private GuiTextField createTextField(int xPosition, int yPosition, GuiBOPPageList.EditBoxEntry field) {
        GuiTextField guitextfield = new GuiTextField(field.getFieldId(), this.field_148161_k.field_71466_p, xPosition, yPosition, 150, 20);
        guitextfield.func_146180_a(field.getLabelText());
        guitextfield.func_175207_a((GuiPageButtonList.GuiResponder)this.responder);
        guitextfield.func_146189_e(field.isVisible());
        guitextfield.func_175205_a(field.getValidator());
        return guitextfield;
    }

    private GuiLabel createLabel(int xPosition, int yPosition, GuiBOPPageList.GuiLabelEntry field, boolean hasNoNeighbor) {
        GuiLabel guilabel = hasNoNeighbor ? new GuiLabel(this.field_148161_k.field_71466_p, field.getFieldId(), xPosition, yPosition, this.field_148155_a - xPosition * 2, 20, -1) : new GuiLabel(this.field_148161_k.field_71466_p, field.getFieldId(), xPosition, yPosition, 150, 20, -1);
        guilabel.field_146172_j = field.isVisible();
        guilabel.func_175202_a(field.getLabelText());
        guilabel.func_175203_a();
        return guilabel;
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        block1: {
            int j;
            block2: {
                GuiTextField guitextfield;
                block3: {
                    int j2;
                    block4: {
                        if (!(this.focusedGui instanceof GuiTextField)) break block1;
                        guitextfield = (GuiTextField)this.focusedGui;
                        if (GuiScreen.func_175279_e((int)keyCode)) break block2;
                        if (keyCode != 15) break block3;
                        guitextfield.func_146195_b(false);
                        int focusedGuiIndex = this.allTextFieldGuis.indexOf(this.focusedGui);
                        focusedGuiIndex = GuiScreen.func_146272_n() ? (focusedGuiIndex == 0 ? this.allTextFieldGuis.size() - 1 : --focusedGuiIndex) : (focusedGuiIndex == this.allTextFieldGuis.size() - 1 ? 0 : ++focusedGuiIndex);
                        this.focusedGui = (Gui)this.allTextFieldGuis.get(focusedGuiIndex);
                        guitextfield = (GuiTextField)this.focusedGui;
                        guitextfield.func_146195_b(true);
                        int k1 = guitextfield.field_146210_g + this.field_148149_f;
                        j2 = guitextfield.field_146210_g;
                        if (k1 <= this.field_148154_c) break block4;
                        this.field_148169_q += (float)(k1 - this.field_148154_c);
                        break block1;
                    }
                    if (j2 >= this.field_148153_b) break block1;
                    this.field_148169_q = j2;
                    break block1;
                }
                guitextfield.func_146201_a(typedChar, keyCode);
                break block1;
            }
            String s = GuiScreen.func_146277_j();
            String[] astring = s.split(";");
            int k = j = this.allTextFieldGuis.indexOf(this.focusedGui);
            String[] astring1 = astring;
            int l = astring.length;
            for (int i1 = 0; i1 < l; ++i1) {
                String s1 = astring1[i1];
                this.allTextFieldGuis.get(k).func_146180_a(s1);
                k = k == this.allTextFieldGuis.size() - 1 ? 0 : ++k;
                if (k == j) break;
            }
        }
    }

    public GuiBOPPageList.GuiRowEntry getRow(int rowNum) {
        return this.allRows.get(rowNum);
    }

    public int func_148127_b() {
        return this.allRows.size();
    }

    public int func_148139_c() {
        return 400;
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 32;
    }

    @Override
    public GuiListExtended.IGuiListEntry getListEntry(int rowNum) {
        return this.getRow(rowNum);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
        int l = this.func_148124_c(mouseX, mouseY);
        if (l >= 0) {
            GuiBOPPageList.GuiRowEntry row = this.getRow(l);
            if (this.focusedGui != row.focusedGui && this.focusedGui != null && this.focusedGui instanceof GuiTextField) {
                ((GuiTextField)this.focusedGui).func_146195_b(false);
            }
            this.focusedGui = row.focusedGui;
        }
    }
}

