/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.dimension;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.registry.config.DimensionConfig;

public final class DimensionData {
    public static final DimensionData NONE = new DimensionData();
    private static final int SPACE_HEIGHT_OFFSET = 32;
    protected final int dimensionId;
    protected final String name;
    protected int seaLevel;
    protected int skyHeight;
    protected int cloudHeight;
    protected int spaceHeight;
    protected boolean hasHaze = false;
    protected boolean hasAuroras = false;
    protected boolean hasWeather = false;
    protected boolean hasFog = false;
    protected boolean alwaysOutside = false;
    protected boolean playBiomeSounds = true;

    private DimensionData() {
        this.dimensionId = Integer.MIN_VALUE;
        this.name = "<NOT SET>";
    }

    public DimensionData(@Nonnull World world) {
        WorldType wt;
        this.dimensionId = world.field_73011_w.getDimension();
        this.name = world.field_73011_w.func_186058_p().func_186065_b();
        this.seaLevel = world.func_181545_F();
        this.cloudHeight = this.skyHeight = world.func_72940_L();
        this.spaceHeight = this.skyHeight + 32;
        if (world.field_73011_w.func_76569_d() && world.field_73011_w.func_191066_m()) {
            this.hasWeather = true;
            this.hasAuroras = true;
            this.hasFog = true;
        }
        if ((wt = world.func_175624_G()) == WorldType.field_77138_c) {
            this.seaLevel = 0;
        } else if (this.dimensionId == 0 && ModOptions.biomes.worldSealevelOverride > 0) {
            this.seaLevel = ModOptions.biomes.worldSealevelOverride;
        }
        String dim = Integer.toString(this.dimensionId);
        for (int i = 0; i < ModOptions.biomes.dimensionBlacklist.length; ++i) {
            if (!dim.equals(ModOptions.biomes.dimensionBlacklist[i])) continue;
            this.playBiomeSounds = false;
            break;
        }
    }

    public DimensionData(@Nonnull World world, @Nonnull DimensionConfig entry) {
        this(world);
        if (entry.seaLevel != null) {
            this.seaLevel = entry.seaLevel;
        }
        if (entry.skyHeight != null) {
            this.skyHeight = entry.skyHeight;
        }
        if (entry.hasHaze != null) {
            this.hasHaze = entry.hasHaze;
        }
        if (entry.hasAurora != null) {
            this.hasAuroras = entry.hasAurora;
        }
        if (entry.hasWeather != null) {
            this.hasWeather = entry.hasWeather;
        }
        if (entry.cloudHeight != null) {
            this.cloudHeight = entry.cloudHeight;
        } else {
            int n = this.cloudHeight = this.hasHaze ? this.skyHeight / 2 : this.skyHeight;
        }
        if (entry.hasFog != null) {
            this.hasFog = entry.hasFog;
        }
        if (entry.alwaysOutside != null) {
            this.alwaysOutside = entry.alwaysOutside;
        }
        this.spaceHeight = this.skyHeight + 32;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public String getName() {
        return this.name;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public int getSkyHeight() {
        return this.skyHeight;
    }

    public int getCloudHeight() {
        return this.cloudHeight;
    }

    public int getSpaceHeight() {
        return this.spaceHeight;
    }

    public boolean getHasHaze() {
        return this.hasHaze;
    }

    public boolean getHasAuroras() {
        return this.hasAuroras;
    }

    public boolean getHasWeather() {
        return this.hasWeather;
    }

    public boolean getHasFog() {
        return this.hasFog;
    }

    public boolean getAlwaysOutside() {
        return this.alwaysOutside;
    }

    public boolean getPlayBiomeSounds() {
        return this.playBiomeSounds;
    }

    @Nonnull
    public String toString() {
        MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper((Object)this);
        builder.add("id", this.dimensionId);
        builder.add("name", (Object)this.name);
        builder.add("seaLevel", this.seaLevel);
        builder.add("cloudHeight", this.cloudHeight);
        builder.add("skyHeight", this.skyHeight);
        builder.add("haze", this.hasHaze);
        builder.add("aurora", this.hasAuroras);
        builder.add("weather", this.hasWeather);
        builder.add("fog", this.hasFog);
        return builder.toString();
    }
}

