/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.blockstate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockStateBase;
import net.minecraft.block.state.IBlockState;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.blockstate.BlockStateData;
import org.orecruncher.lib.ReflectedField;

public final class BlockStateUtil {
    private static final ReflectedField.ObjectField<BlockStateBase, BlockStateData> blockStateInfo = new ReflectedField.ObjectField(BlockStateBase.class, "dsurround_blockstate_info", null);

    @Nullable
    public static <T extends BlockStateData> T getStateData(@Nonnull IBlockState state) {
        BlockStateBase base = (BlockStateBase)state;
        BlockStateData result = (BlockStateData)blockStateInfo.get((Object)base);
        if (result == null) {
            RegistryManager.BLOCK.reload();
            result = (BlockStateData)blockStateInfo.get((Object)base);
            if (result == null) {
                ModBase.log().warn("Unable to find BlockStateData for state [%s]", new Object[]{state.toString()});
                result = BlockStateData.DEFAULT;
                blockStateInfo.set((Object)base, (Object)result);
            }
        }
        return (T)result;
    }

    static <T extends BlockStateData> T getStateDataRaw(@Nonnull IBlockState state) {
        return (T)((BlockStateData)blockStateInfo.get((Object)((BlockStateBase)state)));
    }

    public static <T extends BlockStateData> void setStateData(@Nonnull IBlockState state, @Nonnull T data) {
        blockStateInfo.set((Object)((BlockStateBase)state), data);
    }
}

