/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.network;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetworkManager;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.network.Locus;
import org.orecruncher.dsurround.network.PacketEntityData;
import org.orecruncher.dsurround.network.PacketEnvironment;
import org.orecruncher.dsurround.network.PacketServerData;
import org.orecruncher.dsurround.network.PacketSpeechBubble;
import org.orecruncher.dsurround.network.PacketThunder;
import org.orecruncher.dsurround.network.PacketWeatherUpdate;
import org.orecruncher.lib.ReflectedField;
import org.orecruncher.lib.task.Scheduler;

@Mod.EventBusSubscriber(modid="dsurround")
public final class Network {
    private static final ReflectedField.ObjectField<NetworkDispatcher, EntityPlayerMP> player = new ReflectedField.ObjectField(NetworkDispatcher.class, "player", null);
    private static final Set<UUID> blockList = new ObjectOpenHashSet();
    private static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("dsurround");

    public static void initialize() {
        int discriminator = 0;
        NETWORK.registerMessage(PacketWeatherUpdate.PacketHandler.class, PacketWeatherUpdate.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketSpeechBubble.PacketHandler.class, PacketSpeechBubble.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketEntityData.PacketHandler.class, PacketEntityData.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketThunder.PacketHandler.class, PacketThunder.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketEnvironment.PacketHandler.class, PacketEnvironment.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketServerData.PacketHandler.class, PacketServerData.class, ++discriminator, Side.CLIENT);
    }

    @SubscribeEvent
    public static void clientConnect(@Nonnull FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        NetworkDispatcher dispatcher = NetworkDispatcher.get((NetworkManager)event.getManager());
        if (dispatcher != null) {
            try {
                EntityPlayerMP p = (EntityPlayerMP)player.get((Object)dispatcher);
                String version = (String)dispatcher.getModList().get("dsurround");
                if (StringUtils.isEmpty((CharSequence)version)) {
                    blockList.add(p.getPersistentID());
                    ModBase.log().info("Player [%s] connected without having %s installed", new Object[]{p.getDisplayNameString(), "Dynamic Surroundings"});
                } else {
                    blockList.remove(p.getPersistentID());
                    ModBase.log().info("Player [%s] connected with %s %s", new Object[]{p.getDisplayNameString(), "Dynamic Surroundings", version});
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void clientDisconnect(@Nonnull FMLNetworkEvent.ServerDisconnectionFromClientEvent event) {
        NetworkDispatcher dispatcher = NetworkDispatcher.get((NetworkManager)event.getManager());
        if (dispatcher != null) {
            try {
                EntityPlayerMP p = (EntityPlayerMP)player.get((Object)dispatcher);
                blockList.remove(p.getPersistentID());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void clientDisconnect(@Nonnull PlayerEvent.PlayerLoggedOutEvent event) {
        blockList.remove(event.player.getPersistentID());
    }

    @SideOnly(value=Side.CLIENT)
    static void postEvent(@Nonnull Event event) {
        Network.postEvent(Side.CLIENT, event);
    }

    private static void postEvent(@Nonnull Side side, @Nonnull Event event) {
        Scheduler.schedule((Side)side, () -> MinecraftForge.EVENT_BUS.post(event));
    }

    static void postEventServer(@Nonnull Event event) {
        Network.postEvent(Side.SERVER, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendToList(@Nonnull Stream<EntityPlayerMP> players, @Nonnull IMessage msg) {
        SimpleNetworkWrapper simpleNetworkWrapper = NETWORK;
        synchronized (simpleNetworkWrapper) {
            players.forEach(p -> NETWORK.sendTo(msg, p));
        }
    }

    private static <T extends EntityPlayer> Stream<EntityPlayerMP> generateStream(@Nonnull Collection<T> c) {
        return c.stream().filter(p -> !(p instanceof FakePlayer)).filter(p -> !blockList.contains(p.getPersistentID())).map(p -> (EntityPlayerMP)p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToPlayer(@Nonnull EntityPlayerMP player2, @Nonnull IMessage msg) {
        SimpleNetworkWrapper simpleNetworkWrapper = NETWORK;
        synchronized (simpleNetworkWrapper) {
            if (!blockList.contains(player2.getPersistentID())) {
                NETWORK.sendTo(msg, player2);
            }
        }
    }

    public static void sendToEntityViewers(@Nonnull Entity entity, @Nonnull IMessage msg) {
        Set players = ((WorldServer)entity.func_130014_f_()).func_73039_n().getTrackingPlayers(entity);
        Stream<EntityPlayerMP> list = Network.generateStream(players);
        Network.sendToList(list, msg);
    }

    public static void sendToDimension(int dimensionId, @Nonnull IMessage msg) {
        WorldServer world = DimensionManager.getWorld((int)dimensionId);
        if (world != null) {
            Stream<EntityPlayerMP> players = Network.generateStream(DimensionManager.getWorld((int)dimensionId).field_73010_i);
            Network.sendToList(players, msg);
        }
    }

    public static void sendToAll(@Nonnull IMessage msg) {
        Stream<EntityPlayerMP> players = Network.generateStream(FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v());
        Network.sendToList(players, msg);
    }

    public static void sendToAllAround(@Nonnull Locus point, @Nonnull IMessage msg) {
        WorldServer world = DimensionManager.getWorld((int)point.dimension);
        if (world != null) {
            double rSq = point.range * point.range;
            Stream<EntityPlayerMP> players = Network.generateStream(DimensionManager.getWorld((int)point.dimension).field_73010_i).filter(p -> p.func_70092_e(point.x, point.y, point.z) <= rSq);
            Network.sendToList(players, msg);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(@Nonnull IMessage msg) {
        NETWORK.sendToServer(msg);
    }
}

