/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.expression;

import net.minecraft.world.World;
import org.orecruncher.dsurround.capabilities.CapabilitySeasonInfo;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.lib.expression.Dynamic;
import org.orecruncher.lib.expression.DynamicVariantList;
import org.orecruncher.lib.expression.IDynamicVariant;

public class WeatherVariables
extends DynamicVariantList {
    public WeatherVariables() {
        this.add((IDynamicVariant)new Dynamic.DynamicBoolean("weather.isRaining"){

            public void update() {
                this.value = Weather.isRaining();
            }
        });
        this.add((IDynamicVariant)new Dynamic.DynamicBoolean("weather.isThundering"){

            public void update() {
                this.value = Weather.isThundering();
            }
        });
        this.add((IDynamicVariant)new Dynamic.DynamicBoolean("weather.isNotRaining"){

            public void update() {
                this.value = !Weather.isRaining();
            }
        });
        this.add((IDynamicVariant)new Dynamic.DynamicBoolean("weather.isNotThundering"){

            public void update() {
                this.value = !Weather.isThundering();
            }
        });
        this.add((IDynamicVariant)new Dynamic.DynamicNumber("weather.rainfall"){

            public void update() {
                this.value = Weather.getIntensityLevel();
            }
        });
        this.add((IDynamicVariant)new Dynamic.DynamicNumber("weather.temperatureValue"){

            public void update() {
                World world = EnvironStateHandler.EnvironState.getWorld();
                ISeasonInfo season = CapabilitySeasonInfo.getCapability(world);
                this.value = season.getTemperature(EnvironStateHandler.EnvironState.getPlayerPosition());
            }
        });
        this.add((IDynamicVariant)new Dynamic.DynamicString("weather.temperature"){

            public void update() {
                this.value = EnvironStateHandler.EnvironState.getBiomeTemperature().getValue();
            }
        });
        this.add((IDynamicVariant)new Dynamic.DynamicBoolean("weather.canWaterFreeze"){

            public void update() {
                World world = EnvironStateHandler.EnvironState.getWorld();
                ISeasonInfo season = CapabilitySeasonInfo.getCapability(world);
                this.value = season.canWaterFreeze(EnvironStateHandler.EnvironState.getPlayerPosition());
            }
        });
    }
}

