/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.weather;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.capabilities.CapabilityDimensionInfo;
import org.orecruncher.dsurround.capabilities.CapabilitySeasonInfo;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.capabilities.season.PrecipitationType;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.weather.RenderWeather;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.client.weather.compat.RandomThings;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.dsurround.registry.biome.BiomeUtil;
import org.orecruncher.lib.Color;
import org.orecruncher.lib.chunk.ClientChunkCache;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class StormRenderer {
    private static final double[] RAIN_X_COORDS = new double[1024];
    private static final double[] RAIN_Y_COORDS = new double[1024];
    private final Random random = new XorShiftRandom();
    private final BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
    private static ResourceLocation effectTexture;
    private static boolean isDrawing;
    private static BufferBuilder worldrenderer;
    private static int locY;

    private static void setupForRender(@Nonnull ResourceLocation r) {
        if (effectTexture != r) {
            if (worldrenderer == null) {
                worldrenderer = Tessellator.func_178181_a().func_178180_c();
                RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
                worldrenderer.func_178969_c(-manager.field_78730_l, -manager.field_78731_m, -manager.field_78728_n);
                locY = MathHelper.func_76128_c((double)manager.field_78731_m);
            }
            if (isDrawing) {
                Tessellator.func_178181_a().func_78381_a();
            }
            effectTexture = r;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(r);
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            isDrawing = true;
        }
    }

    private static void closeRender() {
        if (isDrawing) {
            Tessellator.func_178181_a().func_78381_a();
        }
        if (worldrenderer != null) {
            worldrenderer.func_178969_c(0.0, 0.0, 0.0);
        }
        isDrawing = false;
        effectTexture = null;
        worldrenderer = null;
    }

    public void render(@Nonnull EntityRenderer renderer, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        if (!CapabilityDimensionInfo.getCapability((World)world).hasWeather()) {
            return;
        }
        float rainStrength = Weather.getIntensityLevel();
        if (rainStrength <= 0.0f) {
            return;
        }
        float alphaRatio = rainStrength / Weather.getMaxIntensityLevel();
        renderer.func_180436_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        int range = mc.field_71474_y.field_74347_j ? 10 : 5;
        float f1 = (float)RenderWeather.rendererUpdateCount + partialTicks;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ISeasonInfo season = CapabilitySeasonInfo.getCapability((World)world);
        Weather.Properties props = Weather.getWeatherProperties();
        Entity entity = mc.func_175606_aa();
        BlockPos playerPos = EnvironStateHandler.EnvironState.getPlayerPosition();
        int playerX = playerPos.func_177958_n();
        int playerY = playerPos.func_177956_o();
        int playerZ = playerPos.func_177952_p();
        for (int gridZ = playerZ - range; gridZ <= playerZ + range; ++gridZ) {
            for (int gridX = playerX - range; gridX <= playerX + range; ++gridX) {
                ResourceLocation texture;
                Color color;
                int l2;
                int idx = (gridZ - playerZ + 16) * 32 + gridX - playerX + 16;
                double rainX = RAIN_X_COORDS[idx];
                double rainY = RAIN_Y_COORDS[idx];
                this.mutable.func_181079_c(gridX, 0, gridZ);
                if (!RandomThings.shouldRain((World)world, (BlockPos)this.mutable)) continue;
                BiomeInfo biome = BiomeUtil.getBiomeData(ClientChunkCache.instance().func_180494_b((BlockPos)this.mutable));
                int precipHeight = season.getPrecipitationHeight((BlockPos)this.mutable).func_177956_o();
                int k2 = Math.max(playerY - range, precipHeight);
                if (k2 == (l2 = Math.max(playerY + range, precipHeight))) continue;
                this.mutable.func_181079_c(gridX, k2, gridZ);
                PrecipitationType pt = season.getPrecipitationType((BlockPos)this.mutable, biome);
                if (pt == PrecipitationType.NONE) continue;
                this.random.setSeed(gridX * gridX * 3121 + gridX * 45238971 ^ gridZ * gridZ * 418711 + gridZ * 13761);
                int i3 = Math.max(precipHeight, locY);
                double d6 = (double)((float)gridX + 0.5f) - entity.field_70165_t;
                double d7 = (double)((float)gridZ + 0.5f) - entity.field_70161_v;
                float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)range;
                this.mutable.func_181079_c(gridX, i3, gridZ);
                int combinedLight = ClientChunkCache.instance().func_175626_b((BlockPos)this.mutable, 0);
                if (pt == PrecipitationType.RAIN) {
                    StormRenderer.setupForRender(props.getRainTexture());
                    double d5 = ((double)(RenderWeather.rendererUpdateCount + gridX * gridX * 3121 + gridX * 45238971 + gridZ * gridZ * 418711 + gridZ * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                    float alpha = ((1.0f - f3 * f3) * 0.5f + 0.5f) * alphaRatio;
                    int slX16 = combinedLight >> 16 & 0xFFFF;
                    int blX16 = combinedLight & 0xFFFF;
                    worldrenderer.func_181662_b((double)gridX - rainX + 0.5, (double)k2, (double)gridZ - rainY + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_187314_a(slX16, blX16).func_181675_d();
                    worldrenderer.func_181662_b((double)gridX + rainX + 0.5, (double)k2, (double)gridZ + rainY + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_187314_a(slX16, blX16).func_181675_d();
                    worldrenderer.func_181662_b((double)gridX + rainX + 0.5, (double)l2, (double)gridZ + rainY + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_187314_a(slX16, blX16).func_181675_d();
                    worldrenderer.func_181662_b((double)gridX - rainX + 0.5, (double)l2, (double)gridZ - rainY + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_187314_a(slX16, blX16).func_181675_d();
                    continue;
                }
                if (pt == PrecipitationType.DUST) {
                    color = biome.getDustColor();
                    texture = props.getDustTexture();
                } else {
                    color = Color.WHITE;
                    texture = props.getSnowTexture();
                }
                StormRenderer.setupForRender(texture);
                double d8 = ((float)(RenderWeather.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                float factor = biome.getHasDust() ? 0.2f : 0.01f;
                double d9 = this.random.nextDouble() + (double)f1 * (double)factor * (double)((float)this.random.nextGaussian());
                double d10 = this.random.nextDouble() + (double)(f1 * (float)this.random.nextGaussian()) * 0.001;
                float alpha = ((1.0f - f3 * f3) * 0.3f + 0.5f) * alphaRatio;
                int cl = (combinedLight * 3 + 0xF000F0) / 4;
                int slX16 = cl >> 16 & 0xFFFF;
                int blX16 = cl & 0xFFFF;
                worldrenderer.func_181662_b((double)gridX - rainX + 0.5, (double)k2, (double)gridZ - rainY + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(color.red, color.green, color.blue, alpha).func_187314_a(slX16, blX16).func_181675_d();
                worldrenderer.func_181662_b((double)gridX + rainX + 0.5, (double)k2, (double)gridZ + rainY + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(color.red, color.green, color.blue, alpha).func_187314_a(slX16, blX16).func_181675_d();
                worldrenderer.func_181662_b((double)gridX + rainX + 0.5, (double)l2, (double)gridZ + rainY + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(color.red, color.green, color.blue, alpha).func_187314_a(slX16, blX16).func_181675_d();
                worldrenderer.func_181662_b((double)gridX - rainX + 0.5, (double)l2, (double)gridZ - rainY + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(color.red, color.green, color.blue, alpha).func_187314_a(slX16, blX16).func_181675_d();
            }
        }
        StormRenderer.closeRender();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        renderer.func_175072_h();
    }

    static {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                double f2 = j - 16;
                double f3 = i - 16;
                double f4 = MathHelper.func_76133_a((double)(f2 * f2 + f3 * f3));
                StormRenderer.RAIN_X_COORDS[i << 5 | j] = -f3 / f4 * 0.5;
                StormRenderer.RAIN_Y_COORDS[i << 5 | j] = f2 / f4 * 0.5;
            }
        }
        effectTexture = null;
        isDrawing = false;
        worldrenderer = null;
    }
}

