/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.sound;

import javax.annotation.Nonnull;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.sound.SoundInstance;
import org.orecruncher.lib.compat.PositionedSoundUtil;

@SideOnly(value=Side.CLIENT)
public class SoundBuilder {
    private final SoundInstance sound;

    private SoundBuilder(@Nonnull SoundEvent evt, @Nonnull SoundCategory cat) {
        this.sound = new SoundInstance(evt, cat);
    }

    public SoundBuilder from(@Nonnull PositionedSound ps) {
        this.sound.setCategory(ps.func_184365_d());
        this.sound.setPosition(ps.func_147649_g(), ps.func_147654_h(), ps.func_147651_i());
        this.sound.setAttenuationType(ps.func_147656_j());
        this.sound.setVolume(PositionedSoundUtil.getVolume((PositionedSound)ps));
        this.sound.setPitch(PositionedSoundUtil.getPitch((PositionedSound)ps));
        return this;
    }

    public SoundBuilder setPosition(float x, float y, float z) {
        this.sound.setPosition(x, y, z);
        return this;
    }

    public SoundBuilder setPosition(@Nonnull BlockPos pos) {
        this.sound.setPosition((Vec3i)pos);
        return this;
    }

    public SoundBuilder setPosition(@Nonnull Vec3d pos) {
        this.sound.setPosition(pos);
        return this;
    }

    public SoundBuilder setVolume(float v) {
        this.sound.setVolume(v);
        return this;
    }

    public SoundBuilder setPitch(float p) {
        this.sound.setPitch(p);
        return this;
    }

    public SoundInstance build() {
        return this.sound;
    }

    public static SoundBuilder builder(@Nonnull SoundEvent evt) {
        return SoundBuilder.builder(evt, SoundCategory.NEUTRAL);
    }

    public static SoundBuilder builder(@Nonnull SoundEvent evt, @Nonnull SoundCategory cat) {
        return new SoundBuilder(evt, cat);
    }

    public static SoundInstance create(@Nonnull SoundEvent evt, @Nonnull SoundCategory cat) {
        return new SoundInstance(evt, cat);
    }
}

