/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.renderer;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.keyboard.KeyHandler;
import org.orecruncher.dsurround.client.renderer.BadgeRenderLayer;
import org.orecruncher.lib.ForgeUtils;

@SideOnly(value=Side.CLIENT)
public final class AnimaniaBadge1
implements BadgeRenderLayer.IItemStackProvider {
    private static final ItemStack WATER_BUCKET = new ItemStack(Items.field_151131_as);
    private static final ItemStack SEEDS = new ItemStack(Items.field_151014_N);
    private static final ItemStack WHEAT = new ItemStack(Items.field_151015_O);
    private static final ItemStack APPLE = new ItemStack(Items.field_151034_e);
    private static final ItemStack CARROT = new ItemStack(Items.field_151172_bF);
    private static final ItemStack EGG = new ItemStack(Items.field_151110_aK);
    private static final ItemStack RABBIT_FOOD = CARROT;
    private static final ItemStack HAMSTER_FOOD;
    private static final BadgeRenderLayer.IShowBadge BADGE_DISPLAY_CHECK;
    private Method food;
    private Method water;
    private ItemStack foodItem;
    private float dY;

    private AnimaniaBadge1(Class<?> clazz, ItemStack food, float dY) {
        try {
            this.food = clazz.getMethod("getFed", new Class[0]);
            this.water = clazz.getMethod("getWatered", new Class[0]);
            this.foodItem = food;
            this.dY = dY;
        }
        catch (Throwable t) {
            this.food = null;
            this.water = null;
        }
    }

    @Override
    public float adjustY() {
        return this.dY;
    }

    @Override
    public ItemStack getStackToDisplay(EntityLivingBase e) {
        if (!this.getWatered((Entity)e)) {
            return WATER_BUCKET;
        }
        if (!this.getFed((Entity)e)) {
            return this.foodItem;
        }
        return ItemStack.field_190927_a;
    }

    private boolean getFed(Entity e) {
        try {
            return (Boolean)this.food.invoke((Object)e, new Object[0]);
        }
        catch (Throwable t) {
            return true;
        }
    }

    private boolean getWatered(Entity e) {
        try {
            return (Boolean)this.water.invoke((Object)e, new Object[0]);
        }
        catch (Throwable t) {
            return true;
        }
    }

    private boolean isValid() {
        return this.food != null && this.water != null;
    }

    private static void add(Map<Class<?>, AnimaniaBadge1> theMap, String className, ItemStack food) {
        AnimaniaBadge1.add(theMap, className, food, 0.0f);
    }

    private static void add(Map<Class<?>, AnimaniaBadge1> theMap, String className, ItemStack food, float dY) {
        try {
            Class<?> clazz = Class.forName(className);
            AnimaniaBadge1 a = new AnimaniaBadge1(clazz, food, dY);
            if (a.isValid()) {
                theMap.put(clazz, a);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void intitialize() {
        Reference2ObjectOpenHashMap classMap = new Reference2ObjectOpenHashMap();
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.chickens.EntityAnimaniaChicken", SEEDS);
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.cows.EntityAnimaniaCow", WHEAT);
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.goats.EntityAnimaniaGoat", WHEAT);
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.horses.EntityAnimaniaHorse", APPLE);
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.peacocks.EntityAnimaniaPeacock", SEEDS);
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.pigs.EntityAnimaniaPig", CARROT);
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.sheep.EntityAnimaniaSheep", WHEAT);
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.rodents.EntityFerretBase", EGG);
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.rodents.EntityHedgehogBase", CARROT);
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.rodents.EntityHamster", HAMSTER_FOOD);
        AnimaniaBadge1.add(classMap, "com.animania.common.entities.rodents.rabbits.EntityAnimaniaRabbit", RABBIT_FOOD);
        RenderManager rm = Minecraft.func_71410_x().func_175598_ae();
        for (ResourceLocation r : EntityList.func_180124_b()) {
            Render renderer;
            Optional<Map.Entry> result;
            Class clazz = EntityList.getClass((ResourceLocation)r);
            if (clazz == null || !(result = classMap.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(clazz)).findFirst()).isPresent() || !((renderer = rm.func_78715_a(clazz)) instanceof RenderLivingBase)) continue;
            ((RenderLivingBase)renderer).func_177094_a((LayerRenderer)new BadgeRenderLayer(BADGE_DISPLAY_CHECK, (BadgeRenderLayer.IItemStackProvider)result.get().getValue()));
        }
    }

    static {
        BADGE_DISPLAY_CHECK = () -> KeyHandler.ANIMANIA_BADGES == null || KeyHandler.ANIMANIA_BADGES.func_151470_d() || KeyHandler.ANIMANIA_BADGES.func_151463_i() == 0;
        Item item = ForgeUtils.getItem((String)"animania:hamster_food");
        HAMSTER_FOOD = item != null ? new ItemStack(item) : ItemStack.field_190927_a;
    }
}

