/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.hud;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilityEntityData;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityData;
import org.orecruncher.dsurround.client.fx.BlockEffect;
import org.orecruncher.dsurround.client.handlers.EffectManager;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.FxHandler;
import org.orecruncher.dsurround.client.hud.GuiOverlay;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.blockstate.BlockStateData;
import org.orecruncher.dsurround.registry.blockstate.BlockStateMatcher;
import org.orecruncher.dsurround.registry.blockstate.BlockStateUtil;
import org.orecruncher.dsurround.registry.footstep.BlockMap;
import org.orecruncher.lib.ItemStackUtil;
import org.orecruncher.lib.MCHelper;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.gui.Panel;
import org.orecruncher.lib.gui.TextPanel;

@SideOnly(value=Side.CLIENT)
public class InspectionHUD
extends GuiOverlay {
    private static final String TEXT_BLOCKSTATE = TextFormatting.DARK_PURPLE + "<BlockState>";
    private static final String TEXT_FOOTSTEP_ACOUSTICS = TextFormatting.DARK_PURPLE + "<Footstep Accoustics>";
    private static final String TEXT_BLOCK_EFFECTS = TextFormatting.DARK_PURPLE + "<Block Effects>";
    private static final String TEXT_ALWAYS_ON_EFFECTS = TextFormatting.DARK_PURPLE + "<Always On Effects>";
    private static final String TEXT_BLOCK_SOUNDS = TextFormatting.DARK_PURPLE + "<Block Sounds>";
    private static final String TEXT_DICTIONARY_NAMES = TextFormatting.DARK_PURPLE + "<Dictionary Names>";
    private final TextPanel textPanel = new TextPanel();

    private static List<String> gatherOreNames(ItemStack stack) {
        ArrayList<String> result = new ArrayList<String>();
        if (ItemStackUtil.isValidItemStack((ItemStack)stack)) {
            for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
                result.add(OreDictionary.getOreName((int)i));
            }
        }
        return result;
    }

    private List<String> gatherBlockText(ItemStack stack, List<String> text, IBlockState state, BlockPos pos) {
        List<String> oreNames;
        if (ItemStackUtil.isValidItemStack((ItemStack)stack)) {
            text.add(TextFormatting.RED + stack.func_82833_r());
            String itemName = ItemStackUtil.getItemName((ItemStack)stack);
            if (itemName != null) {
                text.add("ITEM: " + itemName);
                text.add(TextFormatting.DARK_AQUA + stack.func_77973_b().getClass().getName());
            }
        }
        if (state != null) {
            SoundEffect[] soundEffectArray;
            BlockEffect[] effects2;
            Object data;
            BlockStateMatcher info = BlockStateMatcher.create(state);
            text.add("BLOCK: " + info.toString());
            text.add(TextFormatting.DARK_AQUA + info.getBlock().getClass().getName());
            text.add("Material: " + MCHelper.getMaterialName((Material)state.func_185904_a()));
            SoundType st = state.func_177230_c().getSoundType(state, EnvironStateHandler.EnvironState.getWorld(), pos, (Entity)EnvironStateHandler.EnvironState.getPlayer());
            if (st != null) {
                text.add("Step Sound: " + st.func_185844_d().func_187503_a().toString());
            }
            if (RegistryManager.FOOTSTEPS.hasFootprint(state)) {
                text.add("Footprints Generated");
            }
            text.add(TEXT_BLOCKSTATE);
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)nbt, (IBlockState)state);
            text.add(nbt.toString());
            BlockMap bm = RegistryManager.FOOTSTEPS.getBlockMap();
            if (bm != null) {
                data = new ArrayList();
                bm.collectData(EnvironStateHandler.EnvironState.getWorld(), state, pos, (List<String>)data);
                if (data.size() > 0) {
                    text.add(TEXT_FOOTSTEP_ACOUSTICS);
                    Iterator iterator = data.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        text.add(TextFormatting.GOLD + string);
                    }
                }
            }
            if ((effects2 = ((BlockStateData)(data = BlockStateUtil.getStateData(state))).getEffects()).length > 0) {
                text.add(TEXT_BLOCK_EFFECTS);
                for (BlockEffect e : effects2) {
                    text.add(TextFormatting.GOLD + e.getEffectType().getName());
                }
            }
            if ((effects2 = ((BlockStateData)data).getAlwaysOnEffects()).length > 0) {
                text.add(TEXT_ALWAYS_ON_EFFECTS);
                for (BlockEffect e : effects2) {
                    text.add(TextFormatting.GOLD + e.getEffectType().getName());
                }
            }
            if ((soundEffectArray = ((BlockStateData)data).getSounds()).length > 0) {
                text.add(TEXT_BLOCK_SOUNDS);
                text.add(TextFormatting.DARK_GREEN + "Chance: 1 in " + ((BlockStateData)data).getChance());
                for (SoundEffect s : soundEffectArray) {
                    text.add(TextFormatting.GOLD + s.toString());
                }
            }
        }
        if ((oreNames = InspectionHUD.gatherOreNames(stack)).size() > 0) {
            text.add(TEXT_DICTIONARY_NAMES);
            for (String ore : oreNames) {
                text.add(TextFormatting.GOLD + ore);
            }
        }
        return text;
    }

    private List<String> gatherEntityText(@Nonnull Entity entity, @Nonnull List<String> text) {
        try {
            IEntityData data;
            ResourceLocation key = EntityList.func_191301_a((Entity)entity);
            String keyName = key != null ? key.toString() : "No ID Found";
            text.add(TextFormatting.DARK_AQUA + entity.func_70005_c_());
            text.add(keyName);
            text.add(entity.getClass().getName());
            Set tags = entity.func_184216_O();
            if (tags != null && tags.size() > 0) {
                text.add(TextFormatting.GOLD + "Entity Tags");
                text.addAll(tags);
            }
            if ((data = CapabilityEntityData.getCapability(entity)) != null) {
                text.add(((NBTTagCompound)data.serializeNBT()).toString());
            }
            text.add(TextFormatting.GOLD + "Effects");
            text.addAll(((FxHandler)EffectManager.instance().lookupService(FxHandler.class)).getEffects(entity));
        }
        catch (Exception ex) {
            text.add(TextFormatting.RED + "!! ERROR !!");
        }
        return text;
    }

    private static boolean isHolding() {
        ItemStack held = EnvironStateHandler.EnvironState.getPlayer().func_184586_b(EnumHand.MAIN_HAND);
        return !held.func_190926_b() && held.func_77973_b() == Items.field_151146_bM;
    }

    @Override
    public void doTick(int tickRef) {
        if (tickRef != 0 && tickRef % 5 == 0) {
            this.textPanel.resetText();
            if (ModOptions.logging.enableDebugLogging && InspectionHUD.isHolding()) {
                ArrayList<String> data = new ArrayList<String>();
                RayTraceResult current = Minecraft.func_71410_x().field_71476_x;
                if (current != null) {
                    if (current.field_72308_g != null) {
                        this.gatherEntityText(current.field_72308_g, data);
                    } else {
                        BlockPos targetBlock = current == null || current.func_178782_a() == null ? BlockPos.field_177992_a : current.func_178782_a();
                        IBlockState state = WorldUtils.getBlockState((World)EnvironStateHandler.EnvironState.getWorld(), (BlockPos)targetBlock);
                        if (!WorldUtils.isAirBlock((IBlockState)state)) {
                            ItemStack stack = state != null ? state.func_177230_c().getPickBlock(state, current, EnvironStateHandler.EnvironState.getWorld(), targetBlock, EnvironStateHandler.EnvironState.getPlayer()) : null;
                            this.gatherBlockText(stack, data, state, targetBlock);
                        }
                    }
                }
                if (data.size() > 0) {
                    this.textPanel.setText(data);
                }
            }
        }
    }

    @Override
    public void doRender(@Nonnull RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && this.textPanel.hasText()) {
            int centerX = event.getResolution().func_78326_a() / 2;
            int centerY = 80;
            this.textPanel.render(centerX, 80, Panel.Reference.TOP_CENTER);
        }
    }
}

