/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.footsteps.accents;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilitySeasonInfo;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.capabilities.season.PrecipitationType;
import org.orecruncher.dsurround.client.footsteps.IFootstepAccentProvider;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class RainSplashAccent
implements IFootstepAccentProvider {
    protected final BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();

    @Override
    @Nonnull
    public String getName() {
        return "Rain Splash Accent";
    }

    @Override
    @Nonnull
    public ObjectArray<IAcoustic> provide(@Nonnull EntityLivingBase entity, @Nullable BlockPos blockPos, @Nonnull ObjectArray<IAcoustic> in) {
        if (ModOptions.sound.enablePuddleSound && Weather.isRaining() && EnvironStateHandler.EnvironState.isPlayer((Entity)entity)) {
            PrecipitationType pt;
            int precipHeight;
            if (blockPos != null) {
                this.mutable.func_181079_c(blockPos.func_177958_n(), blockPos.func_177956_o() + 1, blockPos.func_177952_p());
            } else {
                this.mutable.func_189535_a((Entity)entity);
            }
            World world = entity.func_130014_f_();
            ISeasonInfo season = CapabilitySeasonInfo.getCapability(world);
            if (season != null && (precipHeight = season.getPrecipitationHeight((BlockPos)this.mutable).func_177956_o()) == this.mutable.func_177956_o() && (pt = season.getPrecipitationType((BlockPos)this.mutable, null)) == PrecipitationType.RAIN) {
                in.addAll((Object[])RegistryManager.FOOTSTEPS.SPLASH);
            }
        }
        return in;
    }
}

