/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.aurora;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.orecruncher.dsurround.client.aurora.AuroraBase;
import org.orecruncher.dsurround.client.aurora.AuroraUtils;
import org.orecruncher.dsurround.client.aurora.Panel;
import org.orecruncher.dsurround.client.shader.Shaders;
import org.orecruncher.lib.gfx.OpenGlState;
import org.orecruncher.lib.gfx.OpenGlUtil;
import org.orecruncher.lib.gfx.shaders.ShaderProgram;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class AuroraShaderBand
extends AuroraBase {
    protected ShaderProgram program = Shaders.AURORA;
    protected ShaderProgram.IShaderUseCallback callback = shader -> {
        shader.set("time", new float[]{AuroraUtils.getTimeSeconds() * 0.75f});
        shader.set("resolution", new float[]{this.getAuroraWidth(), this.getAuroraHeight()});
        shader.set("topColor", this.getFadeColor());
        shader.set("middleColor", this.getMiddleColor());
        shader.set("bottomColor", this.getBaseColor());
        shader.set("alpha", new float[]{this.getAlpha()});
    };
    protected final float auroraWidth = (float)this.band.getNodeList().length * this.band.getNodeWidth();
    protected final float panelTexWidth = this.band.getNodeWidth() / this.auroraWidth;

    public AuroraShaderBand(long seed) {
        super(seed, true);
    }

    @Override
    protected float getAlpha() {
        return MathStuff.clamp((float)((float)this.band.getAlphaLimit() / 255.0f * this.tracker.ageRatio() * 2.0f), (float)0.0f, (float)1.0f);
    }

    protected float getAuroraWidth() {
        return this.auroraWidth;
    }

    protected float getAuroraHeight() {
        return 18.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(float partialTick) {
        if (this.program == null) {
            return;
        }
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder renderer = tess.func_178180_c();
        double tranY = this.getTranslationY(partialTick);
        double tranX = this.getTranslationX(partialTick);
        double tranZ = this.getTranslationZ(partialTick);
        OpenGlState glState = OpenGlState.push();
        GlStateManager.func_179140_f();
        OpenGlUtil.setAuroraBlend();
        GL11.glFrontFace((int)2304);
        this.band.translate(partialTick);
        Panel[] array = this.band.getNodeList();
        try {
            this.program.use(this.callback);
            for (int b = 0; b < this.bandCount; ++b) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)tranX, (double)tranY, (double)(tranZ + (double)(this.offset * (float)b)));
                GlStateManager.func_179139_a((double)0.5, (double)10.0, (double)0.5);
                renderer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
                for (int i = 0; i < array.length - 1; ++i) {
                    double posY2;
                    double posZ2;
                    double posX2;
                    float v1 = 0.0f;
                    float v2 = 1.0f;
                    float u1 = (float)i * this.panelTexWidth;
                    float u2 = u1 + this.panelTexWidth;
                    Panel node = array[i];
                    double posY = node.getModdedY();
                    double posX = node.tetX;
                    double posZ = node.tetZ;
                    double zero = 0.0;
                    if (i < array.length - 2) {
                        Panel nodePlus = array[i + 1];
                        posX2 = nodePlus.tetX;
                        posZ2 = nodePlus.tetZ;
                        posY2 = nodePlus.getModdedY();
                    } else {
                        posX2 = node.posX;
                        posZ2 = node.getModdedZ();
                        posY2 = 0.0;
                    }
                    renderer.func_181662_b(posX, 0.0, posZ).func_187315_a((double)u1, 0.0).func_181675_d();
                    renderer.func_181662_b(posX, posY, posZ).func_187315_a((double)u1, 1.0).func_181675_d();
                    renderer.func_181662_b(posX2, 0.0, posZ2).func_187315_a((double)u2, 0.0).func_181675_d();
                    renderer.func_181662_b(posX2, posY2, posZ2).func_187315_a((double)u2, 1.0).func_181675_d();
                }
                tess.func_78381_a();
                GlStateManager.func_179121_F();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.program = null;
        }
        finally {
            try {
                if (this.program != null) {
                    this.program.unUse();
                }
            }
            catch (Throwable throwable) {}
        }
        GL11.glFrontFace((int)2305);
        OpenGlState.pop((OpenGlState)glState);
    }

    @Override
    public String toString() {
        return "<SHADER> " + super.toString();
    }
}

