/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities.entitydata;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityRabbit;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.capabilities.CapabilityEntityData;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityDataSettable;

public final class EntityDataTables {
    private static final Set<Class<? extends EntityAIBase>> ATTACK_CLASSES = new ReferenceOpenHashSet();
    private static final Set<Class<? extends EntityAIBase>> FLEE_CLASSES = new ReferenceOpenHashSet();

    public static void add(@Nonnull Class<? extends EntityAIBase> clazz, boolean isAttack) {
        Set<Class<? extends EntityAIBase>> theSet;
        Set<Class<? extends EntityAIBase>> set = theSet = isAttack ? ATTACK_CLASSES : FLEE_CLASSES;
        if (!theSet.contains(clazz)) {
            theSet.add(clazz);
        }
    }

    private static Class<? extends EntityAIBase> findInternalClass(@Nonnull Class<? extends EntityLiving> clazz, @Nonnull String className) {
        Class<?>[] classes;
        for (Class<?> c : classes = clazz.getDeclaredClasses()) {
            if (!c.getName().endsWith(className) || !EntityAIBase.class.isAssignableFrom(c)) continue;
            return c;
        }
        return null;
    }

    private static void registerSpecial(@Nonnull Class<? extends EntityLiving> clazz, @Nonnull String className, boolean isAttack) {
        Class<? extends EntityAIBase> ai = EntityDataTables.findInternalClass(clazz, className);
        if (ai != null) {
            EntityDataTables.add(ai, isAttack);
        } else {
            ModBase.log().warn("Unable to locate class '%s' inside [%s]", new Object[]{className, clazz.toGenericString()});
        }
    }

    @Nonnull
    private static boolean eval(@Nonnull EntityLiving entity, @Nonnull Set<Class<? extends EntityAIBase>> markers) {
        return Stream.of(entity.field_70714_bg.field_75780_b, entity.field_70715_bh.field_75780_b).flatMap(e -> e.stream()).map(t -> t.field_75733_a.getClass()).filter(c -> markers.contains(c)).findFirst().isPresent();
    }

    @Nonnull
    public static void assess(@Nonnull EntityLiving entity) {
        IEntityDataSettable data = (IEntityDataSettable)CapabilityEntityData.getCapability((Entity)entity);
        if (data != null) {
            boolean isAttacking = EntityDataTables.eval(entity, ATTACK_CLASSES);
            boolean isFleeing = EntityDataTables.eval(entity, FLEE_CLASSES);
            data.setAttacking(isAttacking);
            data.setFleeing(isFleeing);
        }
    }

    static {
        EntityDataTables.add(EntityAIAttackMelee.class, true);
        EntityDataTables.add(EntityAIAttackRanged.class, true);
        EntityDataTables.add(EntityAIAttackRangedBow.class, true);
        EntityDataTables.add(EntityAIAvoidEntity.class, false);
        EntityDataTables.add(EntityAICreeperSwell.class, true);
        EntityDataTables.add(EntityAIFleeSun.class, false);
        EntityDataTables.add(EntityAIHurtByTarget.class, false);
        EntityDataTables.add(EntityAILeapAtTarget.class, true);
        EntityDataTables.add(EntityAIOcelotAttack.class, true);
        EntityDataTables.add(EntityAIOwnerHurtByTarget.class, true);
        EntityDataTables.add(EntityAIPanic.class, false);
        EntityDataTables.add(EntityAIRunAroundLikeCrazy.class, false);
        EntityDataTables.add(EntityAIZombieAttack.class, true);
        EntityDataTables.registerSpecial(EntityEnderman.class, "AIFindPlayer", true);
        EntityDataTables.registerSpecial(EntityGhast.class, "AIFireballAttack", true);
        EntityDataTables.registerSpecial(EntityGuardian.class, "AIGuardianAttack", true);
        EntityDataTables.registerSpecial(EntityPolarBear.class, "AIMeleeAttack", true);
        EntityDataTables.registerSpecial(EntityPolarBear.class, "AIPanic", false);
        EntityDataTables.registerSpecial(EntityPolarBear.class, "AIAttackPlayer", true);
        EntityDataTables.registerSpecial(EntityShulker.class, "AIAttackNearest", true);
        EntityDataTables.registerSpecial(EntitySlime.class, "AISlimeAttack", true);
        EntityDataTables.registerSpecial(EntitySpider.class, "AISpiderAttack", true);
        EntityDataTables.registerSpecial(EntityRabbit.class, "AIAvoidEntity", false);
    }
}

