/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities;

import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.orecruncher.dsurround.capabilities.dimension.DimensionInfo;
import org.orecruncher.dsurround.capabilities.dimension.IDimensionInfo;
import org.orecruncher.lib.capability.CapabilityProviderSerializable;
import org.orecruncher.lib.capability.CapabilityUtils;
import org.orecruncher.lib.capability.SimpleStorage;

public class CapabilityDimensionInfo {
    @CapabilityInject(value=IDimensionInfo.class)
    public static final Capability<IDimensionInfo> DIMENSION_INFO = null;
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("dsurround", "dimensioninfo");

    public static void register() {
        CapabilityManager.INSTANCE.register(IDimensionInfo.class, (Capability.IStorage)new SimpleStorage(), DimensionInfo::new);
    }

    public static IDimensionInfo getCapability(@Nonnull World world) {
        return (IDimensionInfo)CapabilityUtils.getCapability((ICapabilityProvider)world, DIMENSION_INFO, null);
    }

    @Nonnull
    public static ICapabilityProvider createProvider(IDimensionInfo data) {
        return new CapabilityProviderSerializable(DIMENSION_INFO, null, (Object)data);
    }

    @Mod.EventBusSubscriber(modid="dsurround")
    public static class EventHandler {
        @SubscribeEvent
        public static void attachCapabilities(@Nonnull AttachCapabilitiesEvent<World> event) {
            World world = (World)event.getObject();
            if (world != null) {
                DimensionInfo info = new DimensionInfo(world);
                event.addCapability(CAPABILITY_ID, CapabilityDimensionInfo.createProvider(info));
            }
        }
    }
}

