/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.subterraneanwaters;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ModConfig {
    public static int[] dimensions;
    public static String[] exclude;
    public static OceanConfig[] configs;
    public static Map<Integer, OceanConfig> map;

    public static void load(Configuration config, File configDir) {
        config.load();
        exclude = config.getStringList("Biomes", "Exclude these Biomes. Use lower case.", new String[]{"deep ocean", "ocean"}, "Biomes to not generate in.");
        dimensions = config.get("Generation", "Dimension IDs", new int[]{0}, "Dimensions to generate in. Configuration file will be created for each dimension on startup. ").getIntList();
        configs = new OceanConfig[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            try {
                int dimID = dimensions[i];
                DimensionType dimension = DimensionType.func_186069_a((int)dimID);
                String name = dimension.func_186065_b();
                File dimFile = new File(configDir, "SubterraneanWaters/" + name + ".cfg");
                Configuration dimConfig = new Configuration(dimFile);
                ModConfig.configs[i] = new OceanConfig();
                configs[i].load(dimConfig);
                map.put(dimID, configs[i]);
                continue;
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Failed to load dimension ocean config!", (Object[])null);
            }
        }
        config.save();
    }

    static {
        map = new HashMap<Integer, OceanConfig>();
    }

    public static class OceanConfig {
        public int lowLimit;
        public int lowOverheadLimit;
        public int highLimit;
        public int highOverheadLimit;
        public int noiseSummand;
        public int liquidLevel;

        public void load(Configuration config) {
            config.load();
            config.addCustomCategoryComment("GenerationVariables", "Height changes with step of 4 during noise generation. So 32 here ~ 128 in world. Some of these values are causing striations.");
            this.lowLimit = config.getInt("LowLimit", "GenerationVariables", 6, 1, 33, "Height at which noise value begins to halt.");
            this.lowOverheadLimit = config.getInt("LowOverheadLimit", "GenerationVariables", 3, 1, 32, "Height at which noise is guaranteed to halt.");
            this.highLimit = config.getInt("HighLimit", "GenerationVariables", 9, 0, 32, "Height at which noise value begins to halt.");
            this.highOverheadLimit = config.getInt("HighOverheadLimit", "GenerationVariables", 12, 1, 32, "Height at which noise is guaranteed to halt.");
            this.noiseSummand = config.getInt("NoiseSummand", "GenerationVariables", -8, -100, 100, "Value simply added to noise before height controling, allows to control size of caverns. Any value above -3 yield enormous caverns.");
            this.liquidLevel = config.getInt("LiquidLevel", "GenerationVariables", 45, 1, 128, "Water level. Actual Y-coordinate in world.");
            config.save();
        }
    }
}

