/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.GBForgetools.GuiElements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import de.guntram.mcmod.GBForgetools.IConfiguration;
import de.guntram.mcmod.GBForgetools.Types.SliderValueConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiSlider
extends Widget {
    Type type;
    boolean dragging;
    double sliderValue;
    double defaultValue;
    double min;
    double max;
    String configOption;
    SliderValueConsumer parent;

    public GuiSlider(SliderValueConsumer optionScreen, int x, int y, int width, int height, IConfiguration config, String option) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent("?"));
        Object value = config.getValue(option);
        if (value instanceof Double) {
            this.func_238482_a_((ITextComponent)new StringTextComponent(Double.toString((Double)value)));
            this.min = (Double)config.getMin(option);
            this.max = (Double)config.getMax(option);
            this.defaultValue = (Double)config.getDefault(option);
            this.sliderValue = ((Double)value - this.min) / (this.max - this.min);
            this.type = Type.DOUBLE;
        } else if (value instanceof Float) {
            this.func_238482_a_((ITextComponent)new StringTextComponent(Float.toString(((Float)value).floatValue())));
            this.min = ((Float)config.getMin(option)).floatValue();
            this.max = ((Float)config.getMax(option)).floatValue();
            this.defaultValue = ((Float)config.getDefault(option)).floatValue();
            this.sliderValue = ((double)((Float)value).floatValue() - this.min) / (this.max - this.min);
            this.type = Type.FLOAT;
        } else {
            this.func_238482_a_((ITextComponent)new StringTextComponent(Integer.toString((Integer)value)));
            this.min = ((Integer)config.getMin(option)).intValue();
            this.max = ((Integer)config.getMax(option)).intValue();
            this.defaultValue = ((Integer)config.getDefault(option)).intValue();
            this.sliderValue = ((double)((Integer)value).intValue() - this.min) / (this.max - this.min);
            this.type = Type.INT;
        }
        this.configOption = option;
        this.parent = optionScreen;
        optionScreen.setMouseReleased(false);
    }

    public GuiSlider(SliderValueConsumer optionScreen, int x, int y, int width, int height, int val, int min, int max, String option) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
        this.func_238482_a_((ITextComponent)new StringTextComponent("" + val));
        this.min = min;
        this.max = max;
        this.sliderValue = (val - min) / (max - min);
        this.type = Type.INT;
        this.configOption = option;
        this.parent = optionScreen;
    }

    public void reinitialize(double value) {
        this.sliderValue = (value - this.min) / (this.max - this.min);
        switch (this.type) {
            case DOUBLE: {
                this.func_238482_a_((ITextComponent)new StringTextComponent(Double.toString(value)));
                break;
            }
            case FLOAT: {
                this.func_238482_a_((ITextComponent)new StringTextComponent(Float.toString((float)value)));
                break;
            }
            case INT: {
                this.func_238482_a_((ITextComponent)new StringTextComponent(Integer.toString((int)value)));
            }
        }
    }

    private void updateValue(double value) {
        switch (this.type) {
            case DOUBLE: {
                double doubleVal = value * (this.max - this.min) + this.min;
                this.func_238482_a_((ITextComponent)new StringTextComponent(String.format("%.2f", doubleVal)));
                this.parent.onConfigChanging(this.configOption, doubleVal);
                break;
            }
            case FLOAT: {
                float floatVal = (float)(value * (this.max - this.min) + this.min);
                this.func_238482_a_((ITextComponent)new StringTextComponent(String.format("%.2f", Float.valueOf(floatVal))));
                this.parent.onConfigChanging(this.configOption, Float.valueOf(floatVal));
                break;
            }
            case INT: {
                int intVal = (int)(value * (this.max - this.min) + this.min + 0.5);
                this.func_238482_a_((ITextComponent)new StringTextComponent(String.format("%d", intVal)));
                this.parent.onConfigChanging(this.configOption, intVal);
            }
        }
    }

    protected void func_230441_a_(MatrixStack stack, Minecraft mc, int mouseX, int mouseY) {
        if (this.field_230694_p_) {
            if (this.dragging) {
                this.sliderValue = (float)(mouseX - (this.field_230690_l_ + 4)) / (float)(this.field_230688_j_ - 8);
                this.sliderValue = MathHelper.func_151237_a((double)this.sliderValue, (double)0.0, (double)1.0);
                this.updateValue(this.sliderValue);
                if (this.parent.wasMouseReleased()) {
                    this.dragging = false;
                }
            }
            mc.func_110434_K().func_110577_a(field_230687_i_);
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(stack, this.field_230690_l_ + (int)(this.sliderValue * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, 66, 4, 20);
            this.func_238474_b_(stack, this.field_230690_l_ + (int)(this.sliderValue * (double)(this.field_230688_j_ - 8)) + 4, this.field_230691_m_, 196, 66, 4, 20);
        }
    }

    public final void func_230982_a_(double mouseX, double mouseY) {
        this.sliderValue = (mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8);
        this.sliderValue = MathHelper.func_151237_a((double)this.sliderValue, (double)0.0, (double)1.0);
        this.updateValue(this.sliderValue);
        this.dragging = true;
        this.parent.setMouseReleased(false);
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        this.dragging = false;
    }

    public void func_230995_c_(boolean b) {
        this.sliderValue = (this.defaultValue - this.min) / (this.max - this.min);
        this.updateValue(this.sliderValue);
        super.func_230995_c_(b);
    }

    private static enum Type {
        INT,
        FLOAT,
        DOUBLE;

    }
}

