/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.GBForgetools;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.guntram.mcmod.GBForgetools.ConfigChangedEvent;
import de.guntram.mcmod.GBForgetools.GuiElements.ColorPicker;
import de.guntram.mcmod.GBForgetools.GuiElements.ColorSelector;
import de.guntram.mcmod.GBForgetools.GuiElements.GuiSlider;
import de.guntram.mcmod.GBForgetools.ModConfigurationHandler;
import de.guntram.mcmod.GBForgetools.Types.ConfigurationMinecraftColor;
import de.guntram.mcmod.GBForgetools.Types.ConfigurationTrueColor;
import de.guntram.mcmod.GBForgetools.Types.SliderValueConsumer;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiModOptions
extends Screen
implements Supplier<Screen>,
SliderValueConsumer {
    private final Screen parent;
    private final String modName;
    private final ModConfigurationHandler handler;
    private final List<String> options;
    private final Logger LOGGER;
    private String screenTitle;
    private static final int LINEHEIGHT = 25;
    private static final int BUTTONHEIGHT = 20;
    private static final int TOP_BAR_SIZE = 40;
    private static final int BOTTOM_BAR_SIZE = 35;
    private boolean isDraggingScrollbar = false;
    private boolean mouseReleased = false;
    private int buttonWidth;
    private int scrollAmount;
    private int maxScroll;
    private static final ITextComponent trueText = new TranslationTextComponent("de.guntram.mcmod.fabrictools.true").func_240699_a_(TextFormatting.GREEN);
    private static final ITextComponent falseText = new TranslationTextComponent("de.guntram.mcmod.fabrictools.false").func_240699_a_(TextFormatting.RED);
    private ColorSelector colorSelector;
    private ColorPicker colorPicker;

    public GuiModOptions(Screen parent, String modName, ModConfigurationHandler confHandler) {
        super((ITextComponent)new StringTextComponent(modName));
        this.parent = parent;
        this.modName = modName;
        this.handler = confHandler;
        this.screenTitle = modName + " Configuration";
        this.options = this.handler.getIConfig().getKeys();
        this.LOGGER = LogManager.getLogger();
        this.colorSelector = new ColorSelector(this, new StringTextComponent("Minecraft Color"));
        this.colorPicker = new ColorPicker(this, 0xFFFFFF, (ITextComponent)new StringTextComponent("RGB Color"));
    }

    protected void func_231160_c_() {
        this.buttonWidth = this.field_230708_k_ / 2 - 50;
        if (this.buttonWidth > 200) {
            this.buttonWidth = 200;
        }
        this.func_230480_a_(new Widget(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 27, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done")){

            public void func_230982_a_(double x, double y) {
                if (((GuiModOptions)GuiModOptions.this).colorSelector.field_230694_p_) {
                    GuiModOptions.this.subscreenFinished();
                    return;
                }
                if (((GuiModOptions)GuiModOptions.this).colorPicker.field_230694_p_) {
                    GuiModOptions.this.colorPicker.onDoneButton();
                    return;
                }
                for (Widget button : GuiModOptions.this.field_230710_m_) {
                    if (!(button instanceof TextFieldWidget) || !button.func_230999_j_()) continue;
                    button.func_231049_c__(false);
                }
                GuiModOptions.this.handler.onConfigChanged(new ConfigChangedEvent.OnConfigChangedEvent(GuiModOptions.this.modName));
                GuiModOptions.this.field_230706_i_.func_147108_a(GuiModOptions.this.parent);
            }
        });
        int y = 25;
        for (final String option : this.options) {
            Widget element;
            y += 25;
            Object value = this.handler.getIConfig().getValue(option);
            if (value == null) {
                LogManager.getLogger().warn("value null, adding nothing");
                continue;
            }
            if (this.handler.getIConfig().isSelectList(option)) {
                final String[] options = this.handler.getIConfig().getListOptions(option);
                element = this.func_230480_a_(new Widget(this.field_230708_k_ / 2 + 10, y, this.buttonWidth, 20, (ITextComponent)new TranslationTextComponent(options[(Integer)value])){

                    public void func_230982_a_(double x, double y) {
                        int cur = (Integer)GuiModOptions.this.handler.getIConfig().getValue(option);
                        if (++cur == options.length) {
                            cur = 0;
                        }
                        GuiModOptions.this.onConfigChanging(option, cur);
                        this.func_231049_c__(true);
                    }

                    public void func_230995_c_(boolean b) {
                        int cur = (Integer)GuiModOptions.this.handler.getIConfig().getValue(option);
                        this.func_238482_a_((ITextComponent)new TranslationTextComponent(options[cur]));
                        super.func_230995_c_(b);
                    }
                });
            } else if (value instanceof Boolean) {
                element = this.func_230480_a_(new Widget(this.field_230708_k_ / 2 + 10, y, this.buttonWidth, 20, (Boolean)value == true ? trueText : falseText){

                    public void func_230982_a_(double x, double y) {
                        if (((Boolean)GuiModOptions.this.handler.getIConfig().getValue(option)).booleanValue()) {
                            GuiModOptions.this.onConfigChanging(option, false);
                        } else {
                            GuiModOptions.this.onConfigChanging(option, true);
                        }
                        this.func_231049_c__(true);
                    }

                    public void func_230995_c_(boolean b) {
                        this.func_238482_a_((Boolean)GuiModOptions.this.handler.getIConfig().getValue(option) == true ? trueText : falseText);
                        super.func_230995_c_(b);
                    }
                });
            } else if (value instanceof String) {
                element = this.func_230480_a_((Widget)new TextFieldWidget(this.getFontRenderer(), this.field_230708_k_ / 2 + 10, y, this.buttonWidth, 20, (ITextComponent)new StringTextComponent((String)value)){

                    public void func_230995_c_(boolean b) {
                        if (b) {
                            GuiModOptions.this.LOGGER.debug("value to textfield");
                            this.func_146180_a((String)GuiModOptions.this.handler.getIConfig().getValue(option));
                        } else {
                            GuiModOptions.this.LOGGER.debug("textfield to value");
                            GuiModOptions.this.handler.getIConfig().setValue(option, this.func_146179_b());
                        }
                        super.func_230995_c_(b);
                    }

                    public boolean func_231042_a_(char chr, int keyCode) {
                        boolean result = super.func_231042_a_(chr, keyCode);
                        GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, option, this.func_146179_b()));
                        return result;
                    }

                    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
                        boolean result = super.func_231046_a_(keyCode, scanCode, modifiers);
                        GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, option, this.func_146179_b()));
                        return result;
                    }
                });
                ((TextFieldWidget)element).func_146203_f(120);
                element.func_231049_c__(false);
            } else if (value instanceof ConfigurationMinecraftColor || value instanceof Integer && (Integer)this.handler.getIConfig().getMin(option) == 0 && (Integer)this.handler.getIConfig().getMax(option) == 15) {
                if (value instanceof Integer) {
                    this.handler.getIConfig().setValue(option, new ConfigurationMinecraftColor((Integer)value));
                }
                element = this.func_230480_a_(new Widget(this.field_230708_k_ / 2 + 10, y, this.buttonWidth, 20, StringTextComponent.field_240750_d_){

                    public void func_230982_a_(double x, double y) {
                        GuiModOptions.this.enableColorSelector(option, this);
                    }

                    public void func_238482_a_(ITextComponent ignored) {
                        Object o = GuiModOptions.this.handler.getIConfig().getValue(option);
                        int newIndex = ((ConfigurationMinecraftColor)o).colorIndex;
                        super.func_238482_a_((ITextComponent)new TranslationTextComponent("de.guntram.mcmod.fabrictools.color").func_240699_a_(TextFormatting.func_175744_a((int)newIndex)));
                    }

                    public boolean func_231049_c__(boolean ignored) {
                        this.func_238482_a_(null);
                        return ignored;
                    }
                });
                element.func_238482_a_(StringTextComponent.field_240750_d_);
            } else if (value instanceof ConfigurationTrueColor || value instanceof Integer && (Integer)this.handler.getIConfig().getMin(option) == 0 && (Integer)this.handler.getIConfig().getMax(option) == 0xFFFFFF) {
                if (value instanceof Integer) {
                    this.handler.getIConfig().setValue(option, new ConfigurationTrueColor((Integer)value));
                }
                element = this.func_230480_a_(new Widget(this.field_230708_k_ / 2 + 10, y, this.buttonWidth, 20, StringTextComponent.field_240750_d_){

                    public void func_230982_a_(double x, double y) {
                        GuiModOptions.this.enableColorPicker(option, this);
                    }

                    public void func_238482_a_(ITextComponent ignored) {
                        Object o = GuiModOptions.this.handler.getIConfig().getValue(option);
                        int rgb = ((ConfigurationTrueColor)o).getInt();
                        super.func_238482_a_((ITextComponent)new TranslationTextComponent("de.guntram.mcmod.fabrictools.color").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)rgb))));
                    }

                    public boolean func_231049_c__(boolean ignored) {
                        this.func_238482_a_(null);
                        return ignored;
                    }
                });
                element.func_238482_a_(StringTextComponent.field_240750_d_);
            } else if (value instanceof Integer || value instanceof Float || value instanceof Double) {
                element = this.func_230480_a_(new GuiSlider(this, this.field_230708_k_ / 2 + 10, y, this.buttonWidth, 20, this.handler.getIConfig(), option));
            } else {
                LogManager.getLogger().warn(this.modName + " has option " + option + " with data type " + value.getClass().getName());
                continue;
            }
            this.func_230480_a_(new Widget(this.field_230708_k_ / 2 + 10 + this.buttonWidth + 10, y, 20, 20, StringTextComponent.field_240750_d_){

                public void func_230982_a_(double x, double y) {
                    Object value = GuiModOptions.this.handler.getIConfig().getValue(option);
                    Object defValue = GuiModOptions.this.handler.getIConfig().getDefault(option);
                    if (value instanceof ConfigurationMinecraftColor) {
                        defValue = new ConfigurationMinecraftColor((Integer)defValue);
                    } else if (value instanceof ConfigurationTrueColor) {
                        defValue = new ConfigurationTrueColor((Integer)defValue);
                    }
                    GuiModOptions.this.onConfigChanging(option, defValue);
                    element.func_231049_c__(false);
                }
            });
        }
        this.maxScroll = this.options.size() * 25 - (this.field_230709_l_ - 40 - 35) + 25;
        if (this.maxScroll < 0) {
            this.maxScroll = 0;
        }
        this.colorSelector.init();
        this.colorPicker.init();
        this.func_230480_a_(this.colorSelector);
        this.func_230480_a_(this.colorPicker);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        this.scrollAmount -= (int)(amount * 20.0 / 2.0);
        if (this.scrollAmount < 0) {
            this.scrollAmount = 0;
        }
        if (this.scrollAmount > this.maxScroll) {
            this.scrollAmount = this.maxScroll;
        }
        return true;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        if (this.colorSelector.field_230694_p_) {
            this.colorSelector.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        } else if (this.colorPicker.field_230694_p_) {
            this.colorPicker.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        } else {
            int y = 52 - this.scrollAmount;
            for (int i = 0; i < this.options.size(); ++i) {
                if (y > 28 && y < this.field_230709_l_ - 35) {
                    this.field_230712_o_.func_238421_b_(stack, new TranslationTextComponent(this.options.get(i)).getString(), (float)(this.field_230708_k_ / 2 - 155), (float)(y + 4), 0xFFFFFF);
                    ((Widget)this.field_230710_m_.get((int)(i * 2 + 1))).field_230691_m_ = y;
                    ((Widget)this.field_230710_m_.get(i * 2 + 1)).func_230430_a_(stack, mouseX, mouseY, partialTicks);
                    ((Widget)this.field_230710_m_.get((int)(i * 2 + 2))).field_230691_m_ = y;
                    ((Widget)this.field_230710_m_.get(i * 2 + 2)).func_230430_a_(stack, mouseX, mouseY, partialTicks);
                }
                y += 25;
            }
            y = 52 - this.scrollAmount;
            for (String text : this.options) {
                if (y > 28 && y < this.field_230709_l_ - 35 && mouseX > this.field_230708_k_ / 2 - 155 && mouseX < this.field_230708_k_ / 2 && mouseY > y && mouseY < y + 20) {
                    String ttText = this.handler.getIConfig().getTooltip(text);
                    if (ttText == null || ttText.isEmpty()) {
                        y += 25;
                        continue;
                    }
                    TranslationTextComponent tooltip = new TranslationTextComponent(this.handler.getIConfig().getTooltip(text));
                    int width = this.field_230712_o_.func_238414_a_((ITextProperties)tooltip);
                    if (width != 0) {
                        if (width <= 250) {
                            this.func_238652_a_(stack, (ITextComponent)tooltip, 0, mouseY);
                        } else {
                            List lines = this.field_230712_o_.func_238425_b_((ITextProperties)tooltip, 250);
                            this.func_238654_b_(stack, lines, 0, mouseY);
                        }
                    }
                }
                y += 25;
            }
            if (this.maxScroll > 0) {
                int pos = (int)((float)(this.field_230709_l_ - 40 - 35 - 20) * ((float)this.scrollAmount / (float)this.maxScroll));
                this.field_230706_i_.func_110434_K().func_110577_a(Widget.field_230687_i_);
                this.func_238474_b_(stack, this.field_230708_k_ - 5, pos + 40, 0, 66, 4, 20);
            }
        }
        this.field_230706_i_.func_110434_K().func_110577_a(AbstractGui.field_230663_f_);
        RenderSystem.disableDepthTest();
        this.func_238474_b_(stack, 0, 0, 0, 0, this.field_230708_k_, 40);
        this.func_238474_b_(stack, 0, this.field_230709_l_ - 35, 0, 0, this.field_230708_k_, 35);
        int n = this.field_230708_k_ / 2;
        this.field_230712_o_.getClass();
        GuiModOptions.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.screenTitle, (int)n, (int)((40 - 9) / 2), (int)0xFFFFFF);
        ((Widget)this.field_230710_m_.get(0)).func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    @Override
    public Screen get() {
        return this;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        if (button == 0) {
            this.mouseReleased = true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.maxScroll > 0 && mouseX > (double)(this.field_230708_k_ - 5)) {
            this.isDraggingScrollbar = true;
            this.scrollAmount = (int)((mouseY - 40.0) / (double)(this.field_230709_l_ - 35 - 40) * (double)this.maxScroll);
            this.scrollAmount = MathHelper.func_76125_a((int)this.scrollAmount, (int)0, (int)this.maxScroll);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar) {
            this.scrollAmount = (int)((mouseY - 40.0) / (double)(this.field_230709_l_ - 35 - 40) * (double)this.maxScroll);
            this.scrollAmount = MathHelper.func_76125_a((int)this.scrollAmount, (int)0, (int)this.maxScroll);
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void enableColorSelector(String option, Widget element) {
        for (int i = 1; i < this.field_230710_m_.size(); ++i) {
            ((Widget)this.field_230710_m_.get((int)i)).field_230694_p_ = false;
        }
        this.colorSelector.setCurrentColor((ConfigurationMinecraftColor)this.handler.getIConfig().getValue(option));
        this.colorSelector.field_230694_p_ = true;
        this.colorSelector.setLink(option, element);
    }

    private void enableColorPicker(String option, Widget element) {
        for (int i = 1; i < this.field_230710_m_.size(); ++i) {
            ((Widget)this.field_230710_m_.get((int)i)).field_230694_p_ = false;
        }
        this.colorPicker.setCurrentColor((ConfigurationTrueColor)this.handler.getIConfig().getValue(option));
        this.colorPicker.field_230694_p_ = true;
        this.colorPicker.setLink(option, element);
    }

    public void subscreenFinished() {
        for (int i = 1; i < this.field_230710_m_.size(); ++i) {
            ((Widget)this.field_230710_m_.get((int)i)).field_230694_p_ = true;
        }
        this.colorSelector.field_230694_p_ = false;
        this.colorPicker.field_230694_p_ = false;
    }

    @Override
    public boolean wasMouseReleased() {
        boolean result = this.mouseReleased;
        this.mouseReleased = false;
        return result;
    }

    @Override
    public void setMouseReleased(boolean value) {
        this.mouseReleased = value;
    }

    @Override
    public void onConfigChanging(String option, Object value) {
        this.handler.getIConfig().setValue(option, value);
        if (value instanceof ConfigurationMinecraftColor) {
            value = ((ConfigurationMinecraftColor)value).colorIndex;
        } else if (value instanceof ConfigurationTrueColor) {
            value = ((ConfigurationTrueColor)value).getInt();
        }
        this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(this.modName, option, value));
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }
}

