/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.ilexiconn.llibrary.server.asm.Descriptors;
import net.ilexiconn.llibrary.server.asm.MappingHandler;
import net.ilexiconn.llibrary.server.asm.Method;
import net.ilexiconn.llibrary.server.asm.MethodPatcher;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassPatcher {
    private String cls;
    private Map<String, MethodPatcher> patcherMap = new HashMap<String, MethodPatcher>();
    private Map<String, Consumer<Method>> creationMap = new HashMap<String, Consumer<Method>>();
    private List<String> removeList = new ArrayList<String>();

    public ClassPatcher(String cls) {
        this.cls = cls;
    }

    void handlePatches(ClassNode classNode) {
        String method;
        FMLRelaunchLog.info((String)("Patching class " + this.cls), (Object[])new Object[0]);
        for (Map.Entry<String, Consumer<Method>> entry : this.creationMap.entrySet()) {
            FMLRelaunchLog.info((String)("   Adding method " + entry.getKey()), (Object[])new Object[0]);
            method = entry.getKey().substring(0, entry.getKey().indexOf("("));
            String desc = entry.getKey().substring(method.length());
            MethodNode methodNode = new MethodNode(1, method, desc, null, null);
            Method m = new Method(this, null);
            entry.getValue().accept(m);
            methodNode.instructions.add(m.insnList);
            classNode.methods.add(methodNode);
        }
        for (MethodNode methodNode : new ArrayList(classNode.methods)) {
            method = methodNode.name + methodNode.desc;
            if (this.removeList.contains(method)) {
                FMLRelaunchLog.info((String)("   Removing method " + method), (Object[])new Object[0]);
                classNode.methods.remove(methodNode);
                continue;
            }
            MethodPatcher patcher = this.patcherMap.get(method);
            if (patcher == null) continue;
            patcher.handlePatches(methodNode);
        }
    }

    public MethodPatcher patchMethod(String method, Object ... params) {
        String desc = MappingHandler.INSTANCE.getClassMapping(Descriptors.method(params));
        method = MappingHandler.INSTANCE.getMethodMapping(this.cls, method, desc) + desc;
        MethodPatcher patcher = new MethodPatcher(this, this.cls, method);
        this.patcherMap.put(method, patcher);
        return patcher;
    }

    public ClassPatcher createMethod(String method, Object[] params, Consumer<Method> consumer) {
        String desc = MappingHandler.INSTANCE.getClassMapping(Descriptors.method(params));
        method = MappingHandler.INSTANCE.getMethodMapping(this.cls, method, desc) + desc;
        this.creationMap.put(method, consumer);
        return this;
    }

    public ClassPatcher removeMethod(String method, Object ... params) {
        String desc = MappingHandler.INSTANCE.getClassMapping(Descriptors.method(params));
        method = MappingHandler.INSTANCE.getMethodMapping(this.cls, method, desc) + desc;
        this.removeList.add(method);
        return this;
    }

    public String toString() {
        return "class:" + this.cls + this.patcherMap.values();
    }
}

