/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.qubble.vanilla;

import net.ilexiconn.llibrary.client.model.qubble.vanilla.QubbleVanillaFace;
import net.ilexiconn.llibrary.client.model.qubble.vanilla.QubbleVanillaRotation;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.INBTSerializable;

public class QubbleVanillaCuboid
implements INBTSerializable<NBTTagCompound> {
    private String name;
    private float fromX;
    private float fromY;
    private float fromZ;
    private float toX;
    private float toY;
    private float toZ;
    private QubbleVanillaRotation rotation;
    private QubbleVanillaFace[] faces = new QubbleVanillaFace[EnumFacing.values().length];
    private boolean shade = true;

    private QubbleVanillaCuboid(String name, String texture) {
        this.name = name;
        for (int i = 0; i < this.faces.length; ++i) {
            this.faces[i] = QubbleVanillaFace.create(EnumFacing.values()[i], texture, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    private QubbleVanillaCuboid() {
    }

    public static QubbleVanillaCuboid create(String name, String texture, float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        QubbleVanillaCuboid cuboid = new QubbleVanillaCuboid(name, texture);
        cuboid.setFrom(fromX, fromY, fromZ);
        cuboid.setTo(toX, toY, toZ);
        return cuboid;
    }

    public static QubbleVanillaCuboid deserialize(NBTTagCompound compound) {
        QubbleVanillaCuboid cuboid = new QubbleVanillaCuboid();
        cuboid.deserializeNBT(compound);
        return cuboid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFace(QubbleVanillaFace face) {
        if (face == null) {
            throw new IllegalArgumentException("Face cannot be null!");
        }
        this.faces[face.getFacing().ordinal()] = face;
    }

    public void setFromX(float fromX) {
        this.fromX = fromX;
    }

    public void setFromY(float fromY) {
        this.fromY = fromY;
    }

    public void setFromZ(float fromZ) {
        this.fromZ = fromZ;
    }

    public void setFrom(float fromX, float fromY, float fromZ) {
        this.fromX = fromX;
        this.fromY = fromY;
        this.fromZ = fromZ;
    }

    public void setToX(float toX) {
        this.toX = toX;
    }

    public void setToY(float toY) {
        this.toY = toY;
    }

    public void setToZ(float toZ) {
        this.toZ = toZ;
    }

    public void setTo(float toX, float toY, float toZ) {
        this.toX = toX;
        this.toY = toY;
        this.toZ = toZ;
    }

    public void setRotation(QubbleVanillaRotation rotation) {
        this.rotation = rotation;
    }

    public void setDimension(float dimensionX, float dimensionY, float dimensionZ) {
        this.toX = this.fromX + dimensionX;
        this.toY = this.fromY + dimensionY;
        this.toZ = this.fromZ + dimensionZ;
    }

    public void setShade(boolean shade) {
        this.shade = shade;
    }

    public String getName() {
        return this.name;
    }

    public float getFromX() {
        return this.fromX;
    }

    public float getFromY() {
        return this.fromY;
    }

    public float getFromZ() {
        return this.fromZ;
    }

    public float getToX() {
        return this.toX;
    }

    public float getToY() {
        return this.toY;
    }

    public float getToZ() {
        return this.toZ;
    }

    public QubbleVanillaRotation getRotation() {
        return this.rotation;
    }

    public QubbleVanillaFace getFace(EnumFacing facing) {
        return this.faces[facing.ordinal()];
    }

    public boolean hasShade() {
        return this.shade;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("name", this.name);
        compound.func_74776_a("fromX", this.fromX);
        compound.func_74776_a("fromY", this.fromY);
        compound.func_74776_a("fromZ", this.fromZ);
        compound.func_74776_a("toX", this.toX);
        compound.func_74776_a("toY", this.toY);
        compound.func_74776_a("toZ", this.toZ);
        compound.func_74757_a("shade", this.shade);
        if (this.rotation != null) {
            compound.func_74782_a("rotation", (NBTBase)this.rotation.serializeNBT());
        }
        NBTTagList faces = new NBTTagList();
        for (QubbleVanillaFace face : this.faces) {
            faces.func_74742_a((NBTBase)face.serializeNBT());
        }
        compound.func_74782_a("faces", (NBTBase)faces);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.name = compound.func_74779_i("name");
        this.setFrom(compound.func_74760_g("fromX"), compound.func_74760_g("fromY"), compound.func_74760_g("fromZ"));
        this.setTo(compound.func_74760_g("toX"), compound.func_74760_g("toY"), compound.func_74760_g("toZ"));
        if (compound.func_74764_b("rotation")) {
            this.rotation = QubbleVanillaRotation.deserialize(compound.func_74775_l("rotation"));
        }
        if (compound.func_74764_b("shade")) {
            this.shade = compound.func_74767_n("shade");
        }
        NBTTagList faces = compound.func_150295_c("faces", 10);
        for (int i = 0; i < faces.func_74745_c(); ++i) {
            this.setFace(QubbleVanillaFace.deserialize(faces.func_150305_b(i)));
        }
    }

    public QubbleVanillaCuboid copy() {
        QubbleVanillaCuboid cuboid = QubbleVanillaCuboid.create(this.name, "none", this.fromX, this.fromY, this.fromZ, this.toX, this.toY, this.toZ);
        if (this.rotation != null) {
            cuboid.setRotation(this.rotation.copy());
        }
        for (QubbleVanillaFace face : this.faces) {
            cuboid.setFace(face.copy());
        }
        cuboid.setShade(this.shade);
        return cuboid;
    }
}

