/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.item.IItemData;
import org.orecruncher.dsurround.registry.item.ItemClass;
import org.orecruncher.dsurround.registry.item.SimpleItemData;
import org.orecruncher.lib.ReflectedField;

@SideOnly(value=Side.CLIENT)
public final class ItemUtils {
    private static final ReflectedField.ObjectField<Item, IItemData> itemInfo = new ReflectedField.ObjectField(Item.class, "dsurround_item_info", null);

    @Nullable
    public static IItemData getItemData(@Nonnull Item item) {
        IItemData result = (IItemData)itemInfo.get((Object)item);
        if (result == null) {
            RegistryManager.ITEMS.reload();
            result = (IItemData)itemInfo.get((Object)item);
            if (result == null) {
                ModBase.log().warn("Unable to find IItemData for item [%s]", new Object[]{item.toString()});
                result = (IItemData)SimpleItemData.CACHE.get((Object)ItemClass.NONE);
                ItemUtils.setItemData(item, result);
            }
        }
        return result;
    }

    public static void setItemData(@Nonnull Item item, @Nonnull IItemData data) {
        itemInfo.set((Object)item, (Object)data);
    }
}

