/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.footstep;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.footsteps.Generator;
import org.orecruncher.dsurround.client.footsteps.GeneratorQP;
import org.orecruncher.dsurround.registry.Registry;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.acoustics.AcousticRegistry;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.acoustics.RainSplashAcoustic;
import org.orecruncher.dsurround.registry.blockstate.BlockStateMatcher;
import org.orecruncher.dsurround.registry.config.ModConfiguration;
import org.orecruncher.dsurround.registry.config.VariatorConfig;
import org.orecruncher.dsurround.registry.effect.EntityEffectInfo;
import org.orecruncher.dsurround.registry.footstep.BlockMap;
import org.orecruncher.dsurround.registry.footstep.Variator;
import org.orecruncher.lib.ItemStackUtil;
import org.orecruncher.lib.MCHelper;
import org.orecruncher.lib.logging.ModLog;

@SideOnly(value=Side.CLIENT)
public final class FootstepsRegistry
extends Registry {
    private static final List<String> FOOTPRINT_SOUND_PROFILE = Arrays.asList("minecraft:block.sand.step", "minecraft:block.gravel.step", "minecraft:block.snow.step");
    private BlockMap blockMap;
    private Set<Material> FOOTPRINT_MATERIAL;
    private Set<IBlockState> FOOTPRINT_STATES;
    private Map<String, Variator> variators;
    private Variator childVariator;
    private Variator playerVariator;
    private Variator playerQuadrupedVariator;
    private Set<IBlockState> missingAcoustics;
    public IAcoustic[] SWIM;
    public IAcoustic[] JUMP;
    public IAcoustic[] SPLASH;

    public FootstepsRegistry() {
        super("Footsteps Registry");
    }

    @Override
    protected void preInit() {
        AcousticRegistry acoustics = RegistryManager.ACOUSTICS;
        this.blockMap = new BlockMap(acoustics);
        this.FOOTPRINT_MATERIAL = new ReferenceOpenHashSet();
        this.FOOTPRINT_STATES = new ReferenceOpenHashSet();
        this.variators = new Object2ObjectOpenHashMap();
        this.FOOTPRINT_MATERIAL.add(Material.field_151571_B);
        this.FOOTPRINT_MATERIAL.add(Material.field_151577_b);
        this.FOOTPRINT_MATERIAL.add(Material.field_151578_c);
        this.FOOTPRINT_MATERIAL.add(Material.field_151588_w);
        this.FOOTPRINT_MATERIAL.add(Material.field_151598_x);
        this.FOOTPRINT_MATERIAL.add(Material.field_151595_p);
        this.FOOTPRINT_MATERIAL.add(Material.field_151596_z);
        this.FOOTPRINT_MATERIAL.add(Material.field_151597_y);
        this.SWIM = null;
        this.JUMP = null;
        this.SPLASH = null;
        this.seedMap();
    }

    @Override
    protected void init(@Nonnull ModConfiguration cfg) {
        for (ModConfiguration.ForgeEntry entry : cfg.forgeMappings) {
            for (String name : entry.dictionaryEntries) {
                this.registerForgeEntries(entry.acousticProfile, name);
            }
        }
        cfg.footsteps.forEach((k, v) -> this.registerBlocks((String)v, (String)k));
        cfg.footprints.forEach(f -> this.registerFootprint((String)f));
        this.variators.putAll(cfg.variators.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Variator((VariatorConfig)e.getValue()))));
    }

    @Override
    protected void postInit() {
        this.SWIM = RegistryManager.ACOUSTICS.compileAcoustics("_SWIM");
        this.JUMP = RegistryManager.ACOUSTICS.compileAcoustics("_JUMP");
        this.SPLASH = new IAcoustic[]{new RainSplashAcoustic(RegistryManager.ACOUSTICS.compileAcoustics("waterfine"))};
        this.childVariator = this.getVariator("child");
        this.playerVariator = this.getVariator(ModOptions.sound.firstPersonFootstepCadence ? "playerSlow" : "player");
        this.playerQuadrupedVariator = this.getVariator(ModOptions.sound.firstPersonFootstepCadence ? "quadrupedSlow" : "quadruped");
        Set blockStates = StreamSupport.stream(ForgeRegistries.BLOCKS.spliterator(), false).map(block -> block.func_176194_O().func_177619_a()).flatMap(l -> l.stream()).collect(Collectors.toSet());
        this.missingAcoustics = blockStates.stream().filter(bs -> !this.getBlockMap().hasAcoustics((IBlockState)bs)).collect(Collectors.toSet());
        blockStates.stream().filter(bs -> bs.func_185904_a().func_76230_c() && !this.hasFootprint((IBlockState)bs)).filter(bs -> {
            ResourceLocation resource;
            SoundEvent event;
            SoundType sound2 = MCHelper.getSoundType((IBlockState)bs);
            if (sound2 != null && (event = sound2.func_185844_d()) != null && (resource = event.func_187503_a()) != null) {
                String soundName = resource.toString();
                return FOOTPRINT_SOUND_PROFILE.contains(soundName);
            }
            return false;
        }).forEach(bs -> this.FOOTPRINT_STATES.add((IBlockState)bs));
    }

    @Override
    protected void complete() {
        if (ModOptions.logging.enableDebugLogging && this.missingAcoustics.size() > 0) {
            ModBase.log().info("          >>>> MISSING ACOUSTIC ENTRIES <<<< ", new Object[0]);
            ModBase.log().info("Sounds for these states will default to their step sound", new Object[0]);
            ModBase.log().info("========================================================", new Object[0]);
            this.missingAcoustics.stream().map(Object::toString).sorted().forEach(arg_0 -> FootstepsRegistry.lambda$complete$9(ModBase.log(), arg_0));
        }
        this.missingAcoustics = null;
    }

    private void seedMap() {
        for (Block block : Block.field_149771_c) {
            String blockName = MCHelper.nameOf((Block)block);
            if (blockName == null) continue;
            if (block instanceof BlockCrops) {
                BlockCrops crop = (BlockCrops)block;
                if (crop.func_185526_g() == 3) {
                    this.registerBlocks("#beets", blockName);
                    continue;
                }
                if (blockName.equals("minecraft:wheat")) {
                    this.registerBlocks("#wheat", blockName);
                    continue;
                }
                if (crop.func_185526_g() != 7) continue;
                this.registerBlocks("#crop", blockName);
                continue;
            }
            if (block instanceof BlockSapling) {
                this.registerBlocks("#sapling", blockName);
                continue;
            }
            if (block instanceof BlockReed) {
                this.registerBlocks("#reed", blockName);
                continue;
            }
            if (block instanceof BlockFence) {
                this.registerBlocks("#fence", blockName);
                continue;
            }
            if (block instanceof BlockVine) {
                this.registerBlocks("#vine", blockName);
                continue;
            }
            if (block instanceof BlockFlower || block instanceof BlockMushroom) {
                this.registerBlocks("NOT_EMITTER", blockName);
                continue;
            }
            if (block instanceof BlockPlanks) {
                this.registerBlocks("wood", blockName);
                continue;
            }
            if (block instanceof BlockLog) {
                this.registerBlocks("log", blockName);
                continue;
            }
            if (block instanceof BlockDoor) {
                this.registerBlocks("bluntwood", blockName);
                continue;
            }
            if (block instanceof BlockLeaves) {
                this.registerBlocks("leaves", blockName);
                continue;
            }
            if (block instanceof BlockOre) {
                this.registerBlocks("ore", blockName);
                continue;
            }
            if (block instanceof BlockIce) {
                this.registerBlocks("ice", blockName);
                continue;
            }
            if (block instanceof BlockChest) {
                this.registerBlocks("squeakywood", blockName);
                continue;
            }
            if (!(block instanceof BlockGlass)) continue;
            this.registerBlocks("glass", blockName);
        }
    }

    public Generator createGenerator(@Nonnull EntityLivingBase entity) {
        EntityEffectInfo info = RegistryManager.EFFECTS.getEffects((Entity)entity);
        Variator var = this.getVariator(info.variator);
        if (entity.func_70631_g_()) {
            var = this.childVariator;
        } else if (entity instanceof EntityPlayer) {
            var = ModOptions.sound.foostepsQuadruped ? this.playerQuadrupedVariator : this.playerVariator;
        }
        return var.QUADRUPED ? new GeneratorQP(var) : new Generator(var);
    }

    @Nonnull
    private Variator getVariator(@Nonnull String varName) {
        return this.variators.getOrDefault(varName, Variator.DEFAULT);
    }

    @Nonnull
    public BlockMap getBlockMap() {
        return this.blockMap;
    }

    @Nonnull
    public IAcoustic[] resolve(@Nonnull IBlockState state) {
        return RegistryManager.ACOUSTICS.resolvePrimitive(state);
    }

    public boolean hasFootprint(@Nonnull IBlockState state) {
        return this.FOOTPRINT_MATERIAL.contains(state.func_185904_a()) || this.FOOTPRINT_STATES.contains(state);
    }

    private static Block resolveToBlock(@Nonnull ItemStack stack) {
        if (!ItemStackUtil.isValidItemStack((ItemStack)stack)) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).func_179223_d();
        }
        if (item instanceof ItemBlockSpecial) {
            return ((ItemBlockSpecial)item).getBlock();
        }
        return null;
    }

    private void registerFootprint(String ... blocks) {
        for (String b : blocks) {
            boolean materialMatch = false;
            if (b.startsWith("@")) {
                materialMatch = true;
                b = b.substring(1);
            }
            BlockStateMatcher bi = BlockStateMatcher.create(b);
            if (materialMatch) {
                IBlockState state = bi.getBlock().func_176223_P();
                this.FOOTPRINT_MATERIAL.add(state.func_185904_a());
                continue;
            }
            this.FOOTPRINT_STATES.addAll(bi.asBlockStates());
        }
    }

    private void registerForgeEntries(@Nonnull String blockClass, String ... entries) {
        for (String dictionaryName : entries) {
            NonNullList stacks = OreDictionary.getOres((String)dictionaryName, (boolean)false);
            for (ItemStack stack : stacks) {
                Block block = FootstepsRegistry.resolveToBlock(stack);
                if (block == null) continue;
                String blockName = null;
                if (stack.func_77981_g() && stack.func_77952_i() != Short.MAX_VALUE) {
                    try {
                        int meta = stack.func_77973_b().getMetadata(stack);
                        IBlockState state = block.func_176203_a(meta);
                        blockName = state.toString();
                    }
                    catch (Throwable t) {
                        ModBase.log().warn("Unable to resolve blockstate for [%s]", new Object[]{ItemStackUtil.getItemName((ItemStack)stack)});
                    }
                } else {
                    blockName = MCHelper.nameOf((Block)block);
                }
                if (blockName != null) {
                    this.getBlockMap().register(blockName, blockClass);
                    continue;
                }
                ModBase.log().warn("Unable to obtain block name for ItemStack [%s]", new Object[]{stack.toString()});
            }
        }
    }

    private void registerBlocks(@Nonnull String blockClass, String ... blocks) {
        for (String s : blocks) {
            this.getBlockMap().register(s, blockClass);
        }
    }

    private static /* synthetic */ void lambda$complete$9(ModLog rec$, String x$0) {
        rec$.info(x$0, new Object[0]);
    }
}

