/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.biome;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.capabilities.season.TemperatureRating;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.biome.BiomeUtil;
import org.orecruncher.dsurround.registry.biome.FakeBiome;
import org.orecruncher.dsurround.registry.biome.IBiome;
import org.orecruncher.dsurround.registry.config.BiomeConfig;
import org.orecruncher.dsurround.registry.config.SoundConfig;
import org.orecruncher.dsurround.registry.config.SoundType;
import org.orecruncher.lib.Color;
import org.orecruncher.lib.MyUtils;
import org.orecruncher.lib.WeightTable;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public final class BiomeInfo
implements Comparable<BiomeInfo> {
    private static final float DEFAULT_FOG_DENSITY = 0.4f;
    private static final Color DEFAULT_FOG_COLOR = new Color(64, 96, 64).asImmutable();
    private static final Color DEFAULT_DUST_COLOR = new Color(255, 234, 151).asImmutable();
    public static final int DEFAULT_SPOT_CHANCE = 250;
    public static final SoundEffect[] NO_SOUNDS = new SoundEffect[0];
    protected final IBiome biome;
    protected boolean hasPrecipitation;
    protected boolean hasDust;
    protected boolean hasAurora;
    protected boolean hasFog;
    private Color dustColor = DEFAULT_DUST_COLOR;
    private Color fogColor = DEFAULT_FOG_COLOR;
    private float fogDensity = 0.4f;
    protected SoundEffect[] sounds = NO_SOUNDS;
    protected SoundEffect[] spotSounds = NO_SOUNDS;
    protected int spotSoundChance = 250;
    protected final List<String> comments = Lists.newArrayList();
    protected final boolean isRiver;
    protected final boolean isOcean;
    protected final boolean isDeepOcean;

    public BiomeInfo(@Nonnull IBiome biome) {
        int color;
        Biome b;
        this.biome = biome;
        if (!this.isFake()) {
            boolean bl = this.hasPrecipitation = this.canRain() || this.getEnableSnow();
        }
        if (!biome.isFake() && BiomeUtil.isBoPBiome(b = biome.getBiome()) && (color = BiomeUtil.getBoPBiomeFogColor(b)) > 0) {
            this.hasFog = true;
            this.fogColor = new Color(color);
            this.fogDensity = BiomeUtil.getBoPBiomeFogDensity(b);
        }
        this.isRiver = this.biome.getTypes().contains(BiomeDictionary.Type.RIVER);
        this.isOcean = this.biome.getTypes().contains(BiomeDictionary.Type.OCEAN);
        this.isDeepOcean = this.isOcean && this.getBiomeName().matches("(?i).*deep.*ocean.*|.*abyss.*");
    }

    public boolean isRiver() {
        return this.isRiver;
    }

    public boolean isOcean() {
        return this.isOcean;
    }

    public boolean isDeepOcean() {
        return this.isDeepOcean;
    }

    public ResourceLocation getKey() {
        return this.biome.getKey();
    }

    public int getBiomeId() {
        return this.biome.getId();
    }

    public Biome getBiome() {
        return this.biome.getBiome();
    }

    public Set<BiomeDictionary.Type> getBiomeTypes() {
        return this.biome.getTypes();
    }

    void addComment(@Nonnull String comment) {
        if (!StringUtils.isEmpty((CharSequence)comment)) {
            this.comments.add(comment);
        }
    }

    public List<String> getComments() {
        return this.comments;
    }

    public String getBiomeName() {
        return this.biome.getName();
    }

    public boolean hasWeatherEffect() {
        return this.getHasPrecipitation() || this.getHasDust();
    }

    public boolean getHasPrecipitation() {
        return this.hasPrecipitation;
    }

    public boolean canRain() {
        return this.biome.canRain();
    }

    public boolean getEnableSnow() {
        return this.biome.getEnableSnow();
    }

    void setHasPrecipitation(boolean flag) {
        this.hasPrecipitation = flag;
    }

    public boolean getHasDust() {
        return this.hasDust;
    }

    void setHasDust(boolean flag) {
        this.hasDust = flag;
    }

    public boolean getHasAurora() {
        return this.hasAurora;
    }

    void setHasAurora(boolean flag) {
        this.hasAurora = flag;
    }

    public boolean getHasFog() {
        return this.hasFog;
    }

    void setHasFog(boolean flag) {
        this.hasFog = flag;
    }

    public Color getDustColor() {
        return this.dustColor;
    }

    void setDustColor(Color color) {
        this.dustColor = color;
    }

    public Color getFogColor() {
        return this.fogColor;
    }

    void setFogColor(@Nonnull Color color) {
        this.fogColor = color;
    }

    public float getFogDensity() {
        return this.fogDensity;
    }

    void setFogDensity(float density) {
        this.fogDensity = density;
    }

    void setSpotSoundChance(int chance) {
        this.spotSoundChance = chance;
    }

    void addSound(SoundEffect sound2) {
        this.sounds = (SoundEffect[])MyUtils.append((Object[])this.sounds, (Object)sound2);
    }

    void addSpotSound(SoundEffect sound2) {
        this.spotSounds = (SoundEffect[])MyUtils.append((Object[])this.spotSounds, (Object)sound2);
    }

    public boolean isFake() {
        return this.biome instanceof FakeBiome;
    }

    public float getFloatTemperature(@Nonnull BlockPos pos) {
        return this.biome.getFloatTemperature(pos);
    }

    public float getTemperature() {
        return this.biome.getTemperature();
    }

    public Biome.TempCategory getTempCategory() {
        return this.biome.getTempCategory();
    }

    public TemperatureRating getTemperatureRating() {
        return TemperatureRating.fromTemp(this.getTemperature());
    }

    public boolean isHighHumidity() {
        return this.biome.isHighHumidity();
    }

    public float getRainfall() {
        return this.biome.getRainfall();
    }

    @Nonnull
    public Collection<SoundEffect> findSoundMatches() {
        return this.findSoundMatches((Collection<SoundEffect>)new ObjectArray(8));
    }

    @Nonnull
    public Collection<SoundEffect> findSoundMatches(@Nonnull Collection<SoundEffect> results) {
        for (int i = 0; i < this.sounds.length; ++i) {
            SoundEffect sound2 = this.sounds[i];
            if (!sound2.matches()) continue;
            results.add(sound2);
        }
        return results;
    }

    @Nullable
    public SoundEffect getSpotSound(@Nonnull Random random) {
        return this.spotSounds != NO_SOUNDS && random.nextInt(this.spotSoundChance) == 0 ? (SoundEffect)new WeightTable((WeightTable.IEntrySource[])this.spotSounds).next() : null;
    }

    void resetSounds() {
        this.sounds = NO_SOUNDS;
        this.spotSounds = NO_SOUNDS;
        this.spotSoundChance = 250;
    }

    public boolean isBiomeType(@Nonnull BiomeDictionary.Type type) {
        return this.getBiomeTypes().contains(type);
    }

    public boolean areBiomesSameClass(@Nonnull Biome biome) {
        return BiomeUtil.areBiomesSimilar(this.biome.getBiome(), biome);
    }

    public void update(@Nonnull BiomeConfig entry) {
        int[] rgb;
        this.addComment(entry.comment);
        if (entry.hasPrecipitation != null) {
            this.setHasPrecipitation(entry.hasPrecipitation);
        }
        if (entry.hasAurora != null) {
            this.setHasAurora(entry.hasAurora);
        }
        if (entry.hasDust != null) {
            this.setHasDust(entry.hasDust);
        }
        if (entry.hasFog != null) {
            this.setHasFog(entry.hasFog);
        }
        if (entry.fogDensity != null) {
            this.setFogDensity(entry.fogDensity.floatValue());
        }
        if (entry.fogColor != null && (rgb = MyUtils.splitToInts((String)entry.fogColor, (char)',')).length == 3) {
            this.setFogColor(new Color(rgb[0], rgb[1], rgb[2]));
        }
        if (entry.dustColor != null && (rgb = MyUtils.splitToInts((String)entry.dustColor, (char)',')).length == 3) {
            this.setDustColor(new Color(rgb[0], rgb[1], rgb[2]));
        }
        if (entry.soundReset != null && entry.soundReset.booleanValue()) {
            this.addComment("> Sound Reset");
            this.resetSounds();
        }
        if (entry.spotSoundChance != null) {
            this.setSpotSoundChance(entry.spotSoundChance);
        }
        for (SoundConfig sr : entry.sounds) {
            if (RegistryManager.SOUND.isSoundBlocked(new ResourceLocation(sr.sound))) continue;
            SoundEffect.Builder b = new SoundEffect.Builder(sr);
            SoundEffect s = b.build();
            if (s.getSoundType() == SoundType.SPOT) {
                this.addSpotSound(s);
                continue;
            }
            this.addSound(s);
        }
    }

    @Nonnull
    public String toString() {
        ResourceLocation rl = this.biome.getKey();
        String registryName = rl == null ? (this.isFake() ? "FAKE" : "UNKNOWN") : rl.toString();
        StringBuilder builder = new StringBuilder();
        builder.append("Biome [").append(this.getBiomeName()).append('/').append(registryName).append("] (").append(this.getBiomeId()).append("):");
        if (!this.isFake()) {
            builder.append("\n+ ").append('<');
            builder.append(this.getBiomeTypes().stream().map(BiomeDictionary.Type::getName).collect(Collectors.joining(",")));
            builder.append('>').append('\n');
            builder.append("+ temp: ").append(this.getTemperature()).append(" (").append(this.getTemperatureRating().getValue()).append(")");
            builder.append(" rain: ").append(this.getRainfall());
        }
        if (this.hasPrecipitation) {
            builder.append(" PRECIPITATION");
        }
        if (this.hasDust) {
            builder.append(" DUST");
        }
        if (this.hasAurora) {
            builder.append(" AURORA");
        }
        if (this.hasFog) {
            builder.append(" FOG");
        }
        if (this.hasDust && this.dustColor != null) {
            builder.append(" dustColor:").append(this.dustColor.toString());
        }
        if (this.hasFog && this.fogColor != null) {
            builder.append(" fogColor:").append(this.fogColor.toString());
            builder.append(" fogDensity:").append(this.fogDensity);
        }
        if (this.sounds.length > 0) {
            builder.append("\n+ sounds [\n");
            builder.append(Arrays.stream(this.sounds).map(c -> "+   " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n+ ]");
        }
        if (this.spotSounds.length > 0) {
            builder.append("\n+ spot sound chance:").append(this.spotSoundChance);
            builder.append("\n+ spot sounds [\n");
            builder.append(Arrays.stream(this.spotSounds).map(c -> "+   " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n+ ]");
        }
        if (this.comments.size() > 0) {
            builder.append("\n+ comments:\n");
            builder.append(this.comments.stream().map(c -> "+   " + c).collect(Collectors.joining("\n")));
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    public int compareTo(@Nonnull BiomeInfo o) {
        return this.getBiomeName().compareTo(o.getBiomeName());
    }
}

