/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.fog;

import javax.annotation.Nonnull;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.handlers.fog.FogResult;
import org.orecruncher.dsurround.client.handlers.fog.IFogRangeCalculator;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class HolisticFogRangeCalculator
implements IFogRangeCalculator {
    protected final ObjectArray<IFogRangeCalculator> calculators = new ObjectArray(8);
    protected final FogResult cached = new FogResult();

    public void add(@Nonnull IFogRangeCalculator calc2) {
        this.calculators.add((Object)calc2);
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        float start = event.getFarPlaneDistance();
        float end = event.getFarPlaneDistance();
        for (int i = 0; i < this.calculators.size(); ++i) {
            FogResult result = ((IFogRangeCalculator)this.calculators.get(i)).calculate(event);
            start = Math.min(start, result.getStart());
            end = Math.min(end, result.getEnd());
        }
        this.cached.set(start, end);
        return this.cached;
    }

    @Override
    public void tick() {
        this.calculators.forEach(IFogRangeCalculator::tick);
    }

    @Nonnull
    public String toString() {
        return this.cached.toString();
    }
}

