/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.fog;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.fog.FogResult;
import org.orecruncher.dsurround.client.handlers.fog.VanillaFogRangeCalculator;
import org.orecruncher.lib.WorldUtils;

@SideOnly(value=Side.CLIENT)
public class BedrockFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected final FogResult cached = new FogResult();
    protected double skyLight;

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        this.cached.set(event);
        if (WorldUtils.hasVoidPartiles((World)EnvironStateHandler.EnvironState.getWorld())) {
            EntityPlayer player2 = EnvironStateHandler.EnvironState.getPlayer();
            double factor = (player2.field_70137_T + (player2.field_70163_u - player2.field_70137_T) * event.getRenderPartialTicks() + 4.0) / 32.0;
            double d0 = this.skyLight / 16.0 + factor;
            float end = event.getFarPlaneDistance();
            if (d0 < 1.0) {
                float f2;
                if (d0 < 0.0) {
                    d0 = 0.0;
                }
                if ((f2 = 100.0f * (float)(d0 *= d0)) < 5.0f) {
                    f2 = 5.0f;
                }
                if (end > f2) {
                    end = f2;
                }
            }
            this.cached.set(event.getFogMode(), end, 0.75f);
        }
        return this.cached;
    }

    @Override
    public void tick() {
        this.skyLight = (EnvironStateHandler.EnvironState.getPlayer().func_70070_b() & 0xF00000) >> 20;
    }
}

