/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.BlockEffectType;
import org.orecruncher.dsurround.client.fx.JetEffect;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleFireJet;
import org.orecruncher.lib.chunk.IBlockAccessEx;

@SideOnly(value=Side.CLIENT)
public class FireJetEffect
extends JetEffect {
    public FireJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.FIRE_JET;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return provider.func_175623_d(pos.func_177984_a()) && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int lavaBlocks = FireJetEffect.countBlocks(provider, pos, s -> s.func_185904_a() == Material.field_151587_i, -1);
        float spawnHeight = BlockLiquid.func_190972_g((IBlockState)state, (IBlockAccess)provider, (BlockPos)pos);
        ParticleFireJet effect = new ParticleFireJet(lavaBlocks, provider.getWorld(), (double)pos.func_177958_n() + 0.5, spawnHeight, (double)pos.func_177952_p() + 0.5);
        this.addEffect(effect);
    }
}

