/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.widget;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.config.KeyBindings;
import codechicken.nei.jei.JEIIntegrationManager;
import codechicken.nei.network.NEIClientPacketHandler;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.util.NEIServerUtils;
import codechicken.nei.util.helper.GuiHelper;
import codechicken.nei.widget.Widget;
import java.awt.Point;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ItemPanel
extends Widget {
    public static ArrayList<ItemStack> items = new ArrayList();
    private static ArrayList<ItemStack> _items = items;
    public ItemStack draggedStack = ItemStack.field_190927_a;
    public int mouseDownSlot = -1;
    private int marginLeft;
    private int marginTop;
    private int rows;
    private int columns;
    private boolean[] validSlotMap;
    private int firstIndex;
    private int itemsPerPage;
    private int page;
    private int numPages;

    public static void updateItemList(ArrayList<ItemStack> newItems) {
        _items = newItems;
    }

    public void resize() {
        items = _items;
        this.marginLeft = this.x + this.w % 18 / 2;
        this.marginTop = this.y + this.h % 18 / 2;
        this.columns = this.w / 18;
        this.rows = this.h / 18;
        if (this.rows < 0) {
            this.rows = 0;
        }
        if (this.columns < 0) {
            this.columns = 0;
        }
        this.calculatePage();
        this.updateValidSlots();
    }

    private void calculatePage() {
        this.numPages = this.itemsPerPage == 0 ? 0 : (int)Math.ceil((float)items.size() / (float)this.itemsPerPage);
        if (this.firstIndex >= items.size()) {
            this.firstIndex = 0;
        }
        this.page = this.numPages == 0 ? 0 : this.firstIndex / this.itemsPerPage + 1;
    }

    private void updateValidSlots() {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        this.validSlotMap = new boolean[this.rows * this.columns];
        this.itemsPerPage = 0;
        for (int i = 0; i < this.validSlotMap.length; ++i) {
            if (!this.slotValid(gui, i)) continue;
            this.validSlotMap[i] = true;
            ++this.itemsPerPage;
        }
    }

    private boolean slotValid(GuiContainer gui, int i) {
        Rectangle4i rect = this.getSlotRect(i);
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            if (!handler.hideItemPanelSlot(gui, rect.x, rect.y, rect.w, rect.h)) continue;
            return false;
        }
        return true;
    }

    public Rectangle4i getSlotRect(int i) {
        return this.getSlotRect(i / this.columns, i % this.columns);
    }

    public Rectangle4i getSlotRect(int row, int column) {
        return new Rectangle4i(this.marginLeft + column * 18, this.marginTop + row * 18, 18, 18);
    }

    @Override
    public void draw(int mousex, int mousey) {
        if (this.itemsPerPage == 0) {
            return;
        }
        GuiHelper.enableMatrixStackLogging();
        int index = this.firstIndex;
        for (int i = 0; i < this.rows * this.columns && index < items.size(); ++i) {
            if (!this.validSlotMap[i]) continue;
            Rectangle4i rect = this.getSlotRect(i);
            if (rect.contains(mousex, mousey)) {
                GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
            }
            GuiHelper.drawItem(rect.x + 1, rect.y + 1, items.get(index));
            ++index;
        }
        GuiHelper.disableMatrixStackLogging();
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        if (!this.draggedStack.func_190926_b()) {
            RenderItem drawItems = GuiHelper.getRenderItem();
            drawItems.field_77023_b += 100.0f;
            GuiHelper.drawItem(mousex - 8, mousey - 8, this.draggedStack);
            drawItems.field_77023_b -= 100.0f;
        }
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (this.mouseDownSlot >= 0 && this.draggedStack.func_190926_b() && NEIClientUtils.getHeldItem().func_190926_b() && NEIClientConfig.hasSMPCounterPart() && !GuiInfo.hasCustomSlots(NEIClientUtils.getGuiContainer())) {
            ItemPanelSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            ItemStack stack = (ItemPanel)this.new ItemPanelSlot((int)this.mouseDownSlot).item;
            if (!(stack.func_190926_b() || mouseOverSlot != null && mouseOverSlot.slotIndex == this.mouseDownSlot && heldTime <= 500L)) {
                int amount = NEIClientConfig.getItemQuantity();
                if (amount == 0) {
                    amount = stack.func_77976_d();
                }
                this.draggedStack = NEIServerUtils.copyStack(stack, amount);
            }
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleDraggedClick(mousex, mousey, button)) {
            return true;
        }
        if (!NEIClientUtils.getHeldItem().func_190926_b()) {
            for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
                if (!handler.hideItemPanelSlot(NEIClientUtils.getGuiContainer(), mousex, mousey, 1, 1)) continue;
                return false;
            }
            if (NEIClientConfig.canPerformAction("delete") && NEIClientConfig.canPerformAction("item")) {
                if (button == 1) {
                    NEIClientUtils.decreaseSlotStack(-999);
                } else {
                    NEIClientUtils.deleteHeldItem();
                }
            } else {
                NEIClientUtils.dropHeldItem();
            }
            return true;
        }
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                ItemStack stack = hoverSlot.item;
                if (!stack.func_190926_b()) {
                    int amount = NEIClientConfig.getItemQuantity();
                    if (amount == 0) {
                        amount = stack.func_77976_d();
                    }
                    this.draggedStack = NEIServerUtils.copyStack(stack, amount);
                }
            } else {
                this.mouseDownSlot = hoverSlot.slotIndex;
            }
            return true;
        }
        return false;
    }

    private boolean handleDraggedClick(int mousex, int mousey, int button) {
        if (this.draggedStack.func_190926_b()) {
            return false;
        }
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        boolean handled = false;
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            if (!handler.handleDragNDrop(gui, mousex, mousey, this.draggedStack, button)) continue;
            handled = true;
            if (this.draggedStack.func_190916_E() != 0) continue;
            this.draggedStack = ItemStack.field_190927_a;
            return true;
        }
        if (handled) {
            return true;
        }
        Slot overSlot = gui.func_146975_c(mousex, mousey);
        if (overSlot != null && overSlot.func_75214_a(this.draggedStack)) {
            if (NEIClientConfig.canCheatItem(this.draggedStack)) {
                int total;
                int add;
                int contents = overSlot.func_75216_d() ? overSlot.func_75211_c().func_190916_E() : 0;
                int n = add = button == 0 ? this.draggedStack.func_190916_E() : 1;
                if (overSlot.func_75216_d() && !NEIServerUtils.areStacksSameType(this.draggedStack, overSlot.func_75211_c())) {
                    contents = 0;
                }
                if ((total = Math.min(contents + add, Math.min(overSlot.func_75219_a(), this.draggedStack.func_77976_d()))) > contents) {
                    int slotNumber = overSlot.field_75222_d;
                    if (gui instanceof GuiContainerCreative) {
                        slotNumber = slotNumber - gui.field_147002_h.field_75151_b.size() + 9 + 36;
                    }
                    NEIClientUtils.setSlotContents(slotNumber, NEIServerUtils.copyStack(this.draggedStack, total), true);
                    NEIClientPacketHandler.sendGiveItem(NEIServerUtils.copyStack(this.draggedStack, total), false, false);
                    this.draggedStack.func_190918_g(total - contents);
                }
                if (this.draggedStack.func_190916_E() == 0) {
                    this.draggedStack = ItemStack.field_190927_a;
                }
            } else {
                this.draggedStack = ItemStack.field_190927_a;
            }
        } else if (mousex < gui.getGuiLeft() || mousey < gui.getGuiTop() || mousex >= gui.getGuiLeft() + gui.getXSize() || mousey >= gui.getGuiTop() + gui.getYSize()) {
            this.draggedStack = ItemStack.field_190927_a;
        }
        return true;
    }

    @Override
    public boolean handleClickExt(int mousex, int mousey, int button) {
        return this.handleDraggedClick(mousex, mousey, button);
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && hoverSlot.slotIndex == this.mouseDownSlot && this.draggedStack.func_190926_b()) {
            ItemStack item = hoverSlot.item;
            if (!NEIClientConfig.canCheatItem(item)) {
                if (button == 0) {
                    JEIIntegrationManager.openRecipeGui(item);
                } else if (button == 1) {
                    JEIIntegrationManager.openUsageGui(item);
                }
                this.draggedStack = ItemStack.field_190927_a;
                this.mouseDownSlot = -1;
                return;
            }
            NEIClientUtils.cheatItem(item, button, -1);
        }
        this.mouseDownSlot = -1;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        this.scroll(-i);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (KeyBindings.get("nei.options.keys.gui.next").isActiveAndMatches(keyID)) {
            this.scroll(1);
            return true;
        }
        if (KeyBindings.get("nei.options.keys.gui.prev").isActiveAndMatches(keyID)) {
            this.scroll(-1);
            return true;
        }
        Point mouse = GuiDraw.getMousePosition();
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mouse.x, mouse.y);
        if (hoverSlot != null && this.draggedStack.func_190926_b()) {
            ItemStack item = hoverSlot.item;
            if (KeyBindings.get("nei.options.keys.gui.recipe").isActiveAndMatches(keyID)) {
                JEIIntegrationManager.openRecipeGui(item);
                return true;
            }
            if (KeyBindings.get("nei.options.keys.gui.usage").isActiveAndMatches(keyID)) {
                JEIIntegrationManager.openUsageGui(item);
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        ItemPanelSlot slot = this.getSlotMouseOver(mousex, mousey);
        return slot == null ? ItemStack.field_190927_a : slot.item;
    }

    public ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        int index = this.firstIndex;
        for (int i = 0; i < this.rows * this.columns && index < items.size(); ++i) {
            if (!this.validSlotMap[i]) continue;
            if (this.getSlotRect(i).contains(mousex, mousey)) {
                return new ItemPanelSlot(index);
            }
            ++index;
        }
        return null;
    }

    public void scroll(int i) {
        if (this.itemsPerPage != 0) {
            int oldIndex = this.firstIndex;
            this.firstIndex += i * this.itemsPerPage;
            if (this.firstIndex >= items.size()) {
                this.firstIndex = 0;
            }
            if (this.firstIndex < 0) {
                this.firstIndex = oldIndex > 0 ? 0 : (items.size() - 1) / this.itemsPerPage * this.itemsPerPage;
            }
            this.calculatePage();
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getNumPages() {
        return this.numPages;
    }

    @Override
    public boolean contains(int px, int py) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        Rectangle4i rect = new Rectangle4i(px, py, 1, 1);
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            if (!handler.hideItemPanelSlot(gui, rect.x, rect.y, rect.w, rect.h)) continue;
            return false;
        }
        return super.contains(px, py);
    }

    public class ItemPanelSlot {
        public ItemStack item;
        public int slotIndex;

        public ItemPanelSlot(int index) {
            this.item = items.get(index);
            this.slotIndex = index;
        }
    }
}

