/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.gui.control;

import cubex2.cxlibrary.gui.control.Anchor;
import cubex2.cxlibrary.gui.control.Control;
import cubex2.cxlibrary.gui.control.ControlBuilder;
import cubex2.cxlibrary.gui.control.ControlContainer;
import cubex2.cxlibrary.gui.data.GuiData;
import cubex2.cxlibrary.lib.GuiTextures;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;

public class Button
extends Control {
    public boolean playSound = true;
    protected boolean hover;
    protected String text = "";

    public Button(String text, Anchor anchor, ControlContainer parent) {
        super(anchor, parent);
        this.setText(text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button, boolean intoControl) {
        if (button == 0 && this.playSound && intoControl) {
            this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    protected String getHoverState(boolean mouseOver) {
        boolean i = true;
        if (!this.isEnabled()) {
            return "button_disabled";
        }
        if (mouseOver) {
            return "button_hover";
        }
        return "button_default";
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.hover = this.isMouseOverControl(mouseX, mouseY);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GuiTextures.MC_WIDGETS.drawPartSliced(this.getHoverState(this.hover), this.getBounds());
        this.drawContent(mouseX, mouseY, partialTicks);
    }

    protected void drawContent(int mouseX, int mouseY, float partialTicks) {
        int l = 0xE0E0E0;
        if (!this.isEnabled()) {
            l = -6250336;
        } else if (this.hover) {
            l = 0xFFFFA0;
        }
        this.func_73732_a(this.mc.field_71466_p, this.text, this.getX() + this.getWidth() / 2, this.getY() + (this.getHeight() - 8) / 2, l);
    }

    public static class Builder
    extends ControlBuilder<Button> {
        private final String text;

        public Builder(String text, GuiData data, String name, ControlContainer parent) {
            super(data, name, parent);
            this.text = text;
        }

        @Override
        protected Button createInstance() {
            return new Button(this.text, this.anchor, this.parent);
        }
    }
}

