/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.gui.control;

import cubex2.cxlibrary.gui.control.Control;
import org.lwjgl.util.Rectangle;

public class Anchor {
    private int width;
    private int height;
    private int distanceLeft;
    private int distanceRight;
    private int distanceTop;
    private int distanceBottom;
    private boolean sameSideLeft = false;
    private boolean sameSideRight = false;
    private boolean sameSideTop = false;
    private boolean sameSideBottom = false;
    private Control controlLeft = null;
    private Control controlRight = null;
    private Control controlTop = null;
    private Control controlBottom = null;

    public Anchor left(Control c, int dist, boolean sameSide) {
        this.controlLeft = c;
        this.distanceLeft = dist;
        this.sameSideLeft = sameSide;
        return this;
    }

    public Anchor right(Control c, int dist, boolean sameSide) {
        this.controlRight = c;
        this.distanceRight = dist;
        this.sameSideRight = sameSide;
        return this;
    }

    public Anchor top(Control c, int dist, boolean sameSide) {
        this.controlTop = c;
        this.distanceTop = dist;
        this.sameSideTop = sameSide;
        return this;
    }

    public Anchor bottom(Control c, int dist, boolean sameSide) {
        this.controlBottom = c;
        this.distanceBottom = dist;
        this.sameSideBottom = sameSide;
        return this;
    }

    public Anchor size(int w, int h) {
        this.width = w;
        this.height = h;
        return this;
    }

    public Anchor width(int w) {
        this.width = w;
        return this;
    }

    public Anchor height(int h) {
        this.height = h;
        return this;
    }

    public Anchor centerHorIn(Control c) {
        return this.left(c, 0, true).right(c, 0, true);
    }

    public Anchor centerVertIn(Control c) {
        return this.top(c, 0, true).bottom(c, 0, true);
    }

    public Anchor centerHorBetween(Control left, Control right) {
        return this.left(left, 0, false).right(right, 0, false);
    }

    public Anchor centerVertBetween(Control top, Control bottom) {
        return this.top(top, 0, false).bottom(bottom, 0, false);
    }

    public Rectangle apply() {
        int x = 0;
        int y = 0;
        int w = this.width;
        int h = this.height;
        if (this.left() && this.right()) {
            if (w > 0) {
                int actW = this.getAnchorRight() - this.distanceRight - (this.getAnchorLeft() + this.distanceLeft);
                x = this.getAnchorLeft() + this.distanceLeft + (actW - w) / 2;
            } else {
                x = this.getAnchorLeft() + this.distanceLeft;
                w = this.getAnchorRight() - this.distanceRight - x;
            }
        } else if (this.left()) {
            x = this.getAnchorLeft() + this.distanceLeft;
        } else if (this.right()) {
            x = this.getAnchorRight() - this.distanceRight - w;
        }
        if (this.top() && this.bottom()) {
            if (h > 0) {
                int actH = this.getAnchorBottom() - this.distanceBottom - (this.getAnchorTop() + this.distanceTop);
                y = this.getAnchorTop() + this.distanceTop + (actH - h) / 2;
            } else {
                y = this.getAnchorTop() + this.distanceTop;
                h = this.getAnchorBottom() - this.distanceBottom - y;
            }
        } else if (this.top()) {
            y = this.getAnchorTop() + this.distanceTop;
        } else if (this.bottom()) {
            y = this.getAnchorBottom() - this.distanceBottom - h;
        }
        return new Rectangle(x, y, w, h);
    }

    private boolean left() {
        return this.controlLeft != null;
    }

    private boolean right() {
        return this.controlRight != null;
    }

    private boolean top() {
        return this.controlTop != null;
    }

    private boolean bottom() {
        return this.controlBottom != null;
    }

    public int getAnchorLeft() {
        return this.controlLeft.getBounds().getX() + (this.sameSideLeft ? 0 : this.controlLeft.getBounds().getWidth());
    }

    public int getAnchorRight() {
        return this.controlRight.getBounds().getX() + (this.sameSideRight ? this.controlRight.getBounds().getWidth() : 0);
    }

    public int getAnchorTop() {
        return this.controlTop.getBounds().getY() + (this.sameSideTop ? 0 : this.controlTop.getBounds().getHeight());
    }

    public int getAnchorBottom() {
        return this.controlBottom.getBounds().getY() + (this.sameSideBottom ? this.controlBottom.getBounds().getHeight() : 0);
    }
}

