/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces.items;

import cubex2.mods.morefurnaces.FurnaceType;
import cubex2.mods.morefurnaces.MoreFurnaces;
import cubex2.mods.morefurnaces.blocks.BlockMoreFurnaces;
import cubex2.mods.morefurnaces.items.Upgrades;
import cubex2.mods.morefurnaces.tileentity.TileEntityIronFurnace;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemUpgrade
extends Item {
    public ItemUpgrade() {
        this.func_77655_b("morefurnacesupgrade");
        this.setRegistryName("upgrade");
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + Upgrades.values()[stack.func_77960_j()].getUnlocalizedName();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < Upgrades.values().length; ++i) {
                subItems.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Upgrades upgrade = Upgrades.values()[stack.func_77960_j()];
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == MoreFurnaces.blockFurnaces ? this.useOnModFurnace(playerIn, world, pos, stack, upgrade) : (state.func_177230_c() == Blocks.field_150460_al || state.func_177230_c() == Blocks.field_150470_am) && upgrade.isVanillaUpgrade() && this.useOnVanillaFurnace(playerIn, world, pos, stack, upgrade)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private boolean useOnVanillaFurnace(EntityPlayer playerIn, World world, BlockPos pos, ItemStack stack, Upgrades upgrade) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)te;
            boolean upgraded = this.upgradeVanillaFurnace(world, pos, furnace, upgrade.getUpgradedType());
            if (upgraded && !playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private boolean useOnModFurnace(EntityPlayer playerIn, World world, BlockPos pos, ItemStack stack, Upgrades upgrade) {
        TileEntityIronFurnace furnace;
        FurnaceType furnaceType;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityIronFurnace && upgrade.canUpgrade(furnaceType = (furnace = (TileEntityIronFurnace)te).getType())) {
            boolean upgraded = this.upgradeFurnace(world, pos, furnace, upgrade.getUpgradedType());
            if (upgraded && !playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private boolean upgradeFurnace(World world, BlockPos pos, TileEntityIronFurnace furnace, FurnaceType to) {
        FurnaceType from = furnace.getType();
        TileEntityIronFurnace newFurnace = FurnaceType.makeEntity(to.ordinal());
        if (newFurnace != null) {
            int[][] fromSlotIds = new int[][]{from.inputSlotIds, from.fuelSlotIds, from.outputSlotIds};
            this.copyInventory((ICapabilityProvider)furnace, fromSlotIds, newFurnace);
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a(BlockMoreFurnaces.VARIANT, (Comparable)((Object)to)));
            world.func_175690_a(pos, (TileEntity)newFurnace);
            newFurnace.copyStateFrom(furnace);
            return true;
        }
        return false;
    }

    private boolean upgradeVanillaFurnace(World world, BlockPos pos, TileEntityFurnace furnace, FurnaceType to) {
        byte facing = (byte)((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockFurnace.field_176447_a)).ordinal();
        TileEntityIronFurnace newFurnace = FurnaceType.makeEntity(to.ordinal());
        if (newFurnace != null) {
            int[][] fromSlotIds = new int[][]{{0}, {1}, {2}};
            this.copyInventory((ICapabilityProvider)furnace, fromSlotIds, newFurnace);
            world.func_175656_a(pos, MoreFurnaces.blockFurnaces.func_176223_P().func_177226_a(BlockMoreFurnaces.VARIANT, (Comparable)((Object)to)));
            world.func_175690_a(pos, (TileEntity)newFurnace);
            newFurnace.copyStateFrom(furnace, facing);
            return true;
        }
        return false;
    }

    private void copyInventory(ICapabilityProvider from, int[][] fromSlotIds, TileEntityIronFurnace to) {
        FurnaceType type = to.getType();
        int[][] toSlotIds = new int[][]{type.inputSlotIds, type.fuelSlotIds, type.outputSlotIds};
        IItemHandlerModifiable fromHandler = (IItemHandlerModifiable)from.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        IItemHandlerModifiable toHandler = (IItemHandlerModifiable)to.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.copyInventory(fromHandler, fromSlotIds, toHandler, toSlotIds);
    }

    private void copyInventory(IItemHandlerModifiable from, int[][] fromSlotIds, IItemHandlerModifiable to, int[][] toSlotIds) {
        for (int i = 0; i < fromSlotIds.length; ++i) {
            int[] slotIds = fromSlotIds[i];
            for (int j = 0; j < slotIds.length; ++j) {
                int fromSlot = slotIds[j];
                if (j >= toSlotIds[i].length) continue;
                int toSlot = toSlotIds[i][j];
                to.setStackInSlot(toSlot, from.getStackInSlot(fromSlot));
                from.setStackInSlot(fromSlot, ItemStack.field_190927_a);
            }
        }
    }
}

