/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.capability.EntityDataCapabilityImplementation;
import net.ilexiconn.llibrary.server.capability.EntityDataHandler;
import net.ilexiconn.llibrary.server.capability.IEntityDataCapability;
import net.ilexiconn.llibrary.server.entity.EntityProperties;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.ilexiconn.llibrary.server.entity.PropertiesTracker;
import net.ilexiconn.llibrary.server.network.PropertiesMessage;
import net.ilexiconn.llibrary.server.world.WorldDataHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public enum ServerEventHandler {
    INSTANCE;

    private int updateTimer;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(new ResourceLocation("llibrary", "ExtendedEntityDataCapability"), (ICapabilityProvider)new ICapabilitySerializable(){

            public NBTBase serializeNBT() {
                Capability<IEntityDataCapability> capability = LLibrary.ENTITY_DATA_CAPABILITY;
                IEntityDataCapability instance = (IEntityDataCapability)capability.getDefaultInstance();
                instance.init((Entity)event.getObject(), ((Entity)event.getObject()).func_130014_f_(), false);
                return capability.getStorage().writeNBT(capability, (Object)instance, null);
            }

            public void deserializeNBT(NBTBase nbt) {
                Capability<IEntityDataCapability> capability = LLibrary.ENTITY_DATA_CAPABILITY;
                IEntityDataCapability instance = (IEntityDataCapability)capability.getDefaultInstance();
                instance.init((Entity)event.getObject(), ((Entity)event.getObject()).func_130014_f_(), true);
                capability.getStorage().readNBT(capability, (Object)instance, null, nbt);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return LLibrary.ENTITY_DATA_CAPABILITY == capability;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                if (capability == LLibrary.ENTITY_DATA_CAPABILITY) {
                    return (T)LLibrary.ENTITY_DATA_CAPABILITY.cast((Object)new EntityDataCapabilityImplementation());
                }
                return null;
            }
        });
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            NBTTagCompound compound = new NBTTagCompound();
            EntityDataCapabilityImplementation.getCapability((Entity)event.getOriginal()).saveToNBT(compound);
            EntityDataCapabilityImplementation.getCapability((Entity)event.getEntityPlayer()).loadFromNBT(compound);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        boolean cached = EntityPropertiesHandler.INSTANCE.hasEntityInCache(event.getEntity().getClass());
        ArrayList<String> entityPropertiesIDCache = !cached ? new ArrayList<String>() : null;
        EntityPropertiesHandler.INSTANCE.getRegisteredProperties().filter(propEntry -> ((Class)propEntry.getKey()).isAssignableFrom(event.getEntity().getClass())).forEach(propEntry -> {
            for (Class propClass : (List)propEntry.getValue()) {
                try {
                    Constructor constructor = propClass.getConstructor(new Class[0]);
                    EntityProperties prop = (EntityProperties)constructor.newInstance(new Object[0]);
                    String propID = prop.getID();
                    EntityDataHandler.INSTANCE.registerExtendedEntityData(event.getEntity(), prop);
                    if (cached) continue;
                    entityPropertiesIDCache.add(propID);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        if (!cached) {
            EntityPropertiesHandler.INSTANCE.addEntityToCache(event.getEntity().getClass(), entityPropertiesIDCache);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        List<PropertiesTracker<?>> trackers = EntityPropertiesHandler.INSTANCE.getEntityTrackers(player);
        if (trackers != null && trackers.size() > 0) {
            PropertiesTracker<?> tracker2;
            boolean hasPlayer = false;
            Iterator<PropertiesTracker<?>> iterator = trackers.iterator();
            while (iterator.hasNext() && !(hasPlayer = (tracker2 = iterator.next()).getEntity() == player)) {
            }
            if (!hasPlayer) {
                EntityPropertiesHandler.INSTANCE.addTracker(player, player);
            }
            for (PropertiesTracker<?> tracker2 : trackers) {
                tracker2.updateTracker();
                if (!tracker2.isTrackerReady()) continue;
                tracker2.onSync();
                PropertiesMessage message = new PropertiesMessage(tracker2.getProperties(), (Entity)tracker2.getEntity());
                LLibrary.NETWORK_WRAPPER.sendTo((IMessage)message, player);
            }
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            EntityPropertiesHandler.INSTANCE.addTracker(player, player);
        }
    }

    @SubscribeEvent
    public void onEntityStartTracking(PlayerEvent.StartTracking event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            EntityPropertiesHandler.INSTANCE.addTracker((EntityPlayerMP)event.getEntityPlayer(), event.getTarget());
        }
    }

    @SubscribeEvent
    public void onEntityStopTracking(PlayerEvent.StopTracking event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            EntityPropertiesHandler.INSTANCE.removeTracker((EntityPlayerMP)event.getEntityPlayer(), event.getTarget());
        }
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++this.updateTimer;
            if (this.updateTimer > 20) {
                this.updateTimer = 0;
                Iterator<Map.Entry<EntityPlayerMP, List<PropertiesTracker<?>>>> iterator = EntityPropertiesHandler.INSTANCE.getTrackerIterator();
                while (iterator.hasNext()) {
                    Map.Entry<EntityPlayerMP, List<PropertiesTracker<?>>> trackerEntry = iterator.next();
                    EntityPlayerMP player = trackerEntry.getKey();
                    WorldServer playerWorld = DimensionManager.getWorld((int)player.field_71093_bK);
                    if (player == null || player.field_70128_L || playerWorld == null || !playerWorld.field_72996_f.contains(player)) {
                        iterator.remove();
                        trackerEntry.getValue().forEach(PropertiesTracker::removeTracker);
                        continue;
                    }
                    Iterator<PropertiesTracker<?>> it = trackerEntry.getValue().iterator();
                    while (it.hasNext()) {
                        PropertiesTracker<?> tracker = it.next();
                        Object entity = tracker.getEntity();
                        WorldServer entityWorld = DimensionManager.getWorld((int)((Entity)entity).field_71093_bK);
                        if (entity != null && !((Entity)entity).field_70128_L && entityWorld != null && entityWorld.field_72996_f.contains(entity)) continue;
                        it.remove();
                        tracker.removeTracker();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            WorldDataHandler.INSTANCE.loadWorldData(event.getWorld().func_72860_G(), event.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K) {
            WorldDataHandler.INSTANCE.saveWorldData(event.getWorld().func_72860_G(), event.getWorld());
        }
    }
}

