/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.items.util;

import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.items.util.EnumSkyrootBucketType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidSkyrootBucketWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private ItemStack container;

    public FluidSkyrootBucketWrapper(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        String fluidName = fluidStack.getFluid().getName();
        return fluidStack.getFluid() == FluidRegistry.WATER || fluidName.equals("inebriation") || fluidName.equals("remedy") || fluidName.equals("milk");
    }

    public FluidStack getFluid() {
        if (this.container.func_77973_b() == ItemsAether.skyroot_bucket && this.container.func_77952_i() == EnumSkyrootBucketType.Water.getMeta()) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (this.container.func_77973_b() == ItemsAether.skyroot_bucket && this.container.func_77952_i() == EnumSkyrootBucketType.Poison.getMeta()) {
            return FluidRegistry.getFluidStack((String)"inebriation", (int)1000);
        }
        if (this.container.func_77973_b() == ItemsAether.skyroot_bucket && this.container.func_77952_i() == EnumSkyrootBucketType.Remedy.getMeta()) {
            return FluidRegistry.getFluidStack((String)"remedy", (int)1000);
        }
        if (this.container.func_77973_b() == ItemsAether.skyroot_bucket && this.container.func_77952_i() == EnumSkyrootBucketType.Milk.getMeta()) {
            return FluidRegistry.getFluidStack((String)"milk", (int)1000);
        }
        return null;
    }

    protected void setFluid(FluidStack fluidStack) {
        if (fluidStack == null) {
            this.container = new ItemStack(ItemsAether.skyroot_bucket);
            return;
        }
        String fluidName = fluidStack.getFluid().getName();
        if (fluidStack.getFluid() == FluidRegistry.WATER) {
            this.container = new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Water.getMeta());
        } else if (fluidName.equals("inebriation")) {
            this.container = new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Poison.getMeta());
        } else if (fluidName.equals("remedy")) {
            this.container = new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Remedy.getMeta());
        } else if (fluidName.equals("milk")) {
            this.container = new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Milk.getMeta());
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 1000 || this.getFluid() != null || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (doFill) {
            this.setFluid(resource);
        }
        return 1000;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || maxDrain < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
        }
        return null;
    }
}

