/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.passive;

import com.legacy.aether.entities.ai.SheepuffAIEatAetherGrass;
import com.legacy.aether.entities.passive.EntityAetherAnimal;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.registry.AetherLootTables;
import com.legacy.aether.registry.sounds.SoundsAether;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySheepuff
extends EntityAetherAnimal
implements IShearable {
    public static final DataParameter<Byte> FLEECE_COLOR = EntityDataManager.func_187226_a(EntitySheepuff.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntitySheepuff.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> PUFFY = EntityDataManager.func_187226_a(EntitySheepuff.class, (DataSerializer)DataSerializers.field_187198_h);
    private SheepuffAIEatAetherGrass entityAIEatGrass;
    private int sheepTimer;
    private int amountEaten;

    public EntitySheepuff(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        this.setFleeceColor(EntitySheepuff.getRandomFleeceColor(this.field_70146_Z));
        this.amountEaten = 0;
    }

    protected void func_184651_r() {
        this.entityAIEatGrass = new SheepuffAIEatAetherGrass(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, ItemsAether.blue_berry, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLEECE_COLOR, (Object)new Byte(0));
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(PUFFY, (Object)false);
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public void func_70615_aA() {
        ++this.amountEaten;
    }

    protected void func_180429_a(BlockPos pos, Block par4) {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187765_eK, SoundCategory.NEUTRAL, 0.15f, 1.0f);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151100_aR && !this.getSheared()) {
            EnumDyeColor color = EnumDyeColor.func_176766_a((int)itemstack.func_77952_i());
            if (this.getFleeceColor() != color) {
                if (this.getPuffed() && itemstack.func_190916_E() >= 2) {
                    this.setFleeceColor(color);
                    itemstack.func_190918_g(2);
                } else if (!this.getPuffed()) {
                    this.setFleeceColor(color);
                    itemstack.func_190918_g(1);
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getFleeceColor().func_176765_a()));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    protected void func_70664_aZ() {
        if (this.getPuffed()) {
            this.field_70181_x = 1.8;
            this.field_70159_w += this.field_70146_Z.nextGaussian() * 0.5;
            this.field_70179_y += this.field_70146_Z.nextGaussian() * 0.5;
        } else {
            this.field_70181_x = 0.42f;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getPuffed()) {
            this.field_70143_R = 0.0f;
            if (this.field_70181_x < -0.05) {
                this.field_70181_x = -0.05;
            }
        }
        if (this.amountEaten >= 2 && !this.getSheared() && !this.getPuffed()) {
            this.setPuffed(true);
            this.amountEaten = 0;
        }
        if (this.amountEaten == 1 && this.getSheared() && !this.getPuffed()) {
            this.setSheared(false);
            this.setFleeceColor(EnumDyeColor.WHITE);
            this.amountEaten = 0;
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Sheared", this.getSheared());
        nbttagcompound.func_74757_a("Puffed", this.getPuffed());
        nbttagcompound.func_74774_a("Color", (byte)this.getFleeceColor().func_176765_a());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setSheared(nbttagcompound.func_74767_n("Sheared"));
        this.setPuffed(nbttagcompound.func_74767_n("Puffed"));
        this.setFleeceColor(EnumDyeColor.func_176764_b((int)nbttagcompound.func_74771_c("Color")));
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.sheepuff_say;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsAether.sheepuff_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.sheepuff_death;
    }

    public EnumDyeColor getFleeceColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(FLEECE_COLOR) & 0xF));
    }

    public void setFleeceColor(EnumDyeColor color) {
        byte byte0 = (Byte)this.field_70180_af.func_187225_a(FLEECE_COLOR);
        this.field_70180_af.func_187227_b(FLEECE_COLOR, (Object)((byte)(byte0 & 0xF0 | color.func_176765_a() & 0xF)));
    }

    public boolean getSheared() {
        return (Boolean)this.field_70180_af.func_187225_a(SHEARED);
    }

    public void setSheared(boolean flag) {
        this.field_70180_af.func_187227_b(SHEARED, (Object)flag);
    }

    public boolean getPuffed() {
        return (Boolean)this.field_70180_af.func_187225_a(PUFFY);
    }

    public void setPuffed(boolean flag) {
        this.field_70180_af.func_187227_b(PUFFY, (Object)flag);
    }

    public static EnumDyeColor getRandomFleeceColor(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return EnumDyeColor.LIGHT_BLUE;
        }
        if (i < 10) {
            return EnumDyeColor.CYAN;
        }
        if (i < 15) {
            return EnumDyeColor.LIME;
        }
        if (i < 18) {
            return EnumDyeColor.PINK;
        }
        return random.nextInt(500) != 0 ? EnumDyeColor.WHITE : EnumDyeColor.PURPLE;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return new EntitySheepuff(this.field_70170_p);
    }

    public float func_70047_e() {
        return 0.95f * this.field_70131_O;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.getSheared()) {
            return AetherLootTables.sheepuff;
        }
        switch (this.getFleeceColor()) {
            default: {
                return AetherLootTables.sheepuff_white;
            }
            case ORANGE: {
                return AetherLootTables.sheepuff_orange;
            }
            case MAGENTA: {
                return AetherLootTables.sheepuff_magenta;
            }
            case LIGHT_BLUE: {
                return AetherLootTables.sheepuff_light_blue;
            }
            case YELLOW: {
                return AetherLootTables.sheepuff_yellow;
            }
            case LIME: {
                return AetherLootTables.sheepuff_lime;
            }
            case PINK: {
                return AetherLootTables.sheepuff_pink;
            }
            case GRAY: {
                return AetherLootTables.sheepuff_gray;
            }
            case SILVER: {
                return AetherLootTables.sheepuff_silver;
            }
            case CYAN: {
                return AetherLootTables.sheepuff_cyan;
            }
            case PURPLE: {
                return AetherLootTables.sheepuff_purple;
            }
            case BLUE: {
                return AetherLootTables.sheepuff_blue;
            }
            case BROWN: {
                return AetherLootTables.sheepuff_brown;
            }
            case GREEN: {
                return AetherLootTables.sheepuff_green;
            }
            case RED: {
                return AetherLootTables.sheepuff_red;
            }
            case BLACK: 
        }
        return AetherLootTables.sheepuff_black;
    }
}

