/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.client;

import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.api.player.IPlayerAether;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.items.accessories.ItemAccessory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;

public class PlayerGloveRenderer {
    private static ModelBiped gloveModel;
    private static ModelBiped slimGloveModel;
    private static boolean isSlim;

    public static void renderItemFirstPerson(AbstractClientPlayer player, float partialTicks, float interpPitch, EnumHand hand, float swingProgress, ItemStack stack, float equipProgress) {
        boolean bl = isSlim = player.func_175154_l().equals("slim");
        if (gloveModel == null && slimGloveModel == null) {
            gloveModel = new ModelBiped(0.01f);
            slimGloveModel = new ModelPlayer(0.01f, true);
        }
        boolean flag = hand == EnumHand.MAIN_HAND;
        EnumHandSide enumhandside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        GlStateManager.func_179094_E();
        if (stack.func_190926_b()) {
            if (flag && !player.func_82150_aj()) {
                PlayerGloveRenderer.renderGloveFirstPerson(player, equipProgress, swingProgress, enumhandside);
            }
        } else if (stack.func_77973_b() instanceof ItemMap) {
            if (flag && player.func_184592_cb().func_190926_b()) {
                PlayerGloveRenderer.renderMapFirstPerson(player, interpPitch, equipProgress, swingProgress);
            } else {
                PlayerGloveRenderer.renderMapFirstPersonSide(player, equipProgress, enumhandside, swingProgress);
            }
        }
        GlStateManager.func_179121_F();
    }

    private static void renderGloves(AbstractClientPlayer player) {
        IPlayerAether playerAether = AetherAPI.getInstance().get((EntityPlayer)player);
        ItemStack accessoryStack = playerAether.getAccessoryInventory().func_70301_a(6);
        if (!accessoryStack.func_190926_b() && accessoryStack.func_77973_b() instanceof ItemAccessory && !player.func_82150_aj()) {
            GlStateManager.func_179129_p();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            PlayerGloveRenderer.renderArm(playerAether, EnumHandSide.RIGHT, (ItemAccessory)accessoryStack.func_77973_b());
            PlayerGloveRenderer.renderArm(playerAether, EnumHandSide.LEFT, (ItemAccessory)accessoryStack.func_77973_b());
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
        }
    }

    private static void renderArm(IPlayerAether playerAether, EnumHandSide hand, ItemAccessory gloves) {
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(!isSlim ? gloves.texture : gloves.texture_slim);
        int colour = gloves.getColorFromItemStack(playerAether.getAccessoryInventory().func_70301_a(6), 0);
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        GlStateManager.func_179094_E();
        if (gloves != ItemsAether.phoenix_gloves) {
            GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
        }
        float f = hand == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.func_179114_b((float)92.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -41.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(f * 0.3f), (float)-1.1f, (float)0.45f);
        if (hand == EnumHandSide.RIGHT) {
            PlayerGloveRenderer.renderRightGlove(playerAether, gloves);
        } else {
            PlayerGloveRenderer.renderLeftArmGlove(playerAether, gloves);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static void renderMapFirstPerson(AbstractClientPlayer player, float interpPitch, float equipProgress, float swingProgress) {
        GlStateManager.func_179094_E();
        float f = MathHelper.func_76129_c((float)swingProgress);
        float f1 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        float f2 = -0.4f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.func_179109_b((float)0.0f, (float)(-f1 / 2.0f), (float)f2);
        float f3 = PlayerGloveRenderer.getMapAngleFromPitch(interpPitch);
        GlStateManager.func_179109_b((float)0.0f, (float)(0.04f + equipProgress * -1.2f + f3 * -0.5f), (float)-0.72f);
        GlStateManager.func_179114_b((float)(f3 * -85.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        PlayerGloveRenderer.renderGloves(player);
        GlStateManager.func_179121_F();
    }

    private static void renderMapFirstPersonSide(AbstractClientPlayer player, float equipProgress, EnumHandSide enumhandside, float swingProgress) {
        float f;
        float f2 = f = enumhandside == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        if (!player.func_82150_aj()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(f * 0.125f), (float)-0.125f, (float)0.0f);
            GlStateManager.func_179114_b((float)(f * 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            PlayerGloveRenderer.renderGloveFirstPerson(player, equipProgress, swingProgress, enumhandside);
            GlStateManager.func_179121_F();
        }
    }

    private static void renderGloveFirstPerson(AbstractClientPlayer player, float equipProgress, float swingProgress, EnumHandSide enumhandside) {
        IPlayerAether playerAether = AetherAPI.getInstance().get((EntityPlayer)player);
        ItemStack accessoryStack = playerAether.getAccessoryInventory().func_70301_a(6);
        if (!accessoryStack.func_190926_b() && accessoryStack.func_77973_b() instanceof ItemAccessory) {
            boolean flag = enumhandside != EnumHandSide.LEFT;
            float f = flag ? 1.0f : -1.0f;
            float f1 = MathHelper.func_76129_c((float)swingProgress);
            float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
            float f4 = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
            GlStateManager.func_179109_b((float)(f * (f2 + 0.64000005f)), (float)(f3 + -0.6f + equipProgress * -0.6f), (float)(f4 + -0.71999997f));
            GlStateManager.func_179114_b((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            float f5 = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
            float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            GlStateManager.func_179114_b((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(f * -1.0f), (float)3.6f, (float)3.5f);
            GlStateManager.func_179114_b((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)(f * 5.6f), (float)0.0f, (float)0.0f);
            GlStateManager.func_179129_p();
            if (flag) {
                PlayerGloveRenderer.renderRightGlove(playerAether, (ItemAccessory)accessoryStack.func_77973_b());
            } else {
                PlayerGloveRenderer.renderLeftArmGlove(playerAether, (ItemAccessory)accessoryStack.func_77973_b());
            }
            GlStateManager.func_179089_o();
        }
    }

    private static void renderRightGlove(IPlayerAether playerAether, ItemAccessory gloves) {
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(!isSlim ? gloves.texture : gloves.texture_slim);
        int colour = gloves.getColorFromItemStack(playerAether.getAccessoryInventory().func_70301_a(6), 0);
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        if (gloves != ItemsAether.phoenix_gloves) {
            GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
        }
        GlStateManager.func_179147_l();
        PlayerGloveRenderer.getModel().field_78095_p = 0.0f;
        PlayerGloveRenderer.getModel().field_78117_n = false;
        PlayerGloveRenderer.getModel().func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)playerAether.getEntity());
        PlayerGloveRenderer.getModel().field_178723_h.field_78795_f = 0.0f;
        PlayerGloveRenderer.getModel().field_178723_h.func_78785_a(0.0625f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderLeftArmGlove(IPlayerAether playerAether, ItemAccessory gloves) {
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(!isSlim ? gloves.texture : gloves.texture_slim);
        int colour = gloves.getColorFromItemStack(playerAether.getAccessoryInventory().func_70301_a(6), 0);
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        if (gloves != ItemsAether.phoenix_gloves) {
            GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
        }
        GlStateManager.func_179147_l();
        PlayerGloveRenderer.getModel().field_78117_n = false;
        PlayerGloveRenderer.getModel().field_78095_p = 0.0f;
        PlayerGloveRenderer.getModel().func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)playerAether.getEntity());
        PlayerGloveRenderer.getModel().field_178724_i.field_78795_f = 0.0f;
        PlayerGloveRenderer.getModel().field_178724_i.func_78785_a(0.0625f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static ModelBiped getModel() {
        return isSlim ? slimGloveModel : gloveModel;
    }

    private static float getMapAngleFromPitch(float pitch) {
        float f = 1.0f - pitch / 45.0f + 0.1f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f = -MathHelper.func_76134_b((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
        return f;
    }

    static {
        isSlim = false;
    }
}

