/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import greymerk.roguelike.treasure.loot.Potion;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;

public class TippedArrow {
    public static ItemStack get(Random rand) {
        return TippedArrow.get(rand, 1);
    }

    public static ItemStack get(Random rand, int amount) {
        Potion type = Potion.values()[rand.nextInt(Potion.values().length)];
        return TippedArrow.get(type, amount);
    }

    public static ItemStack get(Potion type) {
        return TippedArrow.get(type, 1);
    }

    public static ItemStack get(PotionType type) {
        return TippedArrow.get(type, 1);
    }

    public static ItemStack get(Potion type, int amount) {
        PotionType pot = Potion.getEffect(type, false, false);
        return TippedArrow.get(pot, amount);
    }

    public static ItemStack get(PotionType type, int amount) {
        String id = ((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)type)).toString();
        ItemStack arrow = new ItemStack(Items.field_185167_i, amount);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Potion", id);
        arrow.func_77982_d(nbt);
        return arrow;
    }

    public static ItemStack getHarmful(Random rand, int amount) {
        switch (rand.nextInt(4)) {
            case 0: {
                return TippedArrow.get(Potion.HARM, amount);
            }
            case 1: {
                return TippedArrow.get(Potion.POISON, amount);
            }
            case 2: {
                return TippedArrow.get(Potion.SLOWNESS, amount);
            }
            case 3: {
                return TippedArrow.get(Potion.WEAKNESS, amount);
            }
        }
        return new ItemStack(Items.field_151032_g, amount);
    }
}

