/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.expression;

import javax.annotation.Nonnull;
import org.orecruncher.lib.expression.Variant;

public class NumberValue
extends Variant {
    protected float value;

    public NumberValue() {
        this.value = 0.0f;
    }

    public NumberValue(float v) {
        this.value = v;
    }

    public NumberValue(@Nonnull Float v) {
        this.value = v.floatValue();
    }

    public NumberValue(double d) {
        this.value = (float)d;
    }

    public NumberValue(@Nonnull String name) {
        super(name);
        this.value = 0.0f;
    }

    public NumberValue(@Nonnull String name, float v) {
        super(name);
        this.value = v;
    }

    public NumberValue(@Nonnull String name, @Nonnull Float v) {
        super(name);
        this.value = v.floatValue();
    }

    public NumberValue(@Nonnull String name, double d) {
        super(name);
        this.value = (float)d;
    }

    @Override
    public float asNumber() {
        return this.value;
    }

    @Override
    @Nonnull
    public String asString() {
        int i = (int)this.value;
        if ((float)i == this.value) {
            return Integer.toString(i);
        }
        return Float.toString(this.value);
    }

    @Override
    public boolean asBoolean() {
        return this.value != 0.0f;
    }

    @Override
    public int compareTo(@Nonnull Variant variant) {
        return Float.compare(this.value, variant.asNumber());
    }

    @Override
    @Nonnull
    public Variant add(@Nonnull Variant term) {
        return new NumberValue(this.value + term.asNumber());
    }
}

