/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.expression;

import javax.annotation.Nonnull;
import org.orecruncher.lib.expression.BooleanValue;
import org.orecruncher.lib.expression.IDynamicVariant;
import org.orecruncher.lib.expression.NumberValue;
import org.orecruncher.lib.expression.StringValue;
import org.orecruncher.lib.expression.Variant;

public final class Dynamic {
    private Dynamic() {
    }

    public static abstract class DynamicBoolean
    extends BooleanValue
    implements IDynamicVariant<BooleanValue> {
        private boolean needsSet = true;

        public DynamicBoolean(@Nonnull String name) {
            super(name);
        }

        @Override
        public void reset() {
            this.needsSet = true;
        }

        @Override
        public float asNumber() {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.asNumber();
        }

        @Override
        @Nonnull
        public String asString() {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.asString();
        }

        @Override
        public boolean asBoolean() {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.asBoolean();
        }

        @Override
        @Nonnull
        public Variant add(@Nonnull Variant term) {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.add(term);
        }
    }

    public static abstract class DynamicString
    extends StringValue
    implements IDynamicVariant<StringValue> {
        private boolean needsSet = true;

        public DynamicString(@Nonnull String name) {
            super(name, "");
        }

        @Override
        public void reset() {
            this.needsSet = true;
        }

        @Override
        public float asNumber() {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.asNumber();
        }

        @Override
        @Nonnull
        public String asString() {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.asString();
        }

        @Override
        public boolean asBoolean() {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.asBoolean();
        }

        @Override
        @Nonnull
        public Variant add(@Nonnull Variant term) {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.add(term);
        }
    }

    public static abstract class DynamicNumber
    extends NumberValue
    implements IDynamicVariant<NumberValue> {
        private boolean needsSet = true;

        public DynamicNumber(@Nonnull String name) {
            super(name);
        }

        @Override
        public void reset() {
            this.needsSet = true;
        }

        @Override
        public float asNumber() {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.asNumber();
        }

        @Override
        @Nonnull
        public String asString() {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.asString();
        }

        @Override
        public boolean asBoolean() {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.asBoolean();
        }

        @Override
        @Nonnull
        public Variant add(@Nonnull Variant term) {
            if (this.needsSet) {
                this.update();
                this.needsSet = false;
            }
            return super.add(term);
        }
    }
}

