/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.biome.BiomeLayerSampler;
import com.mushroom.midnight.common.biome.MidnightBiomeLayer;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.capability.CavernousBiomeStore;
import com.mushroom.midnight.common.capability.MidnightWorldSpawners;
import com.mushroom.midnight.common.capability.MultiLayerBiomeSampler;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.registry.ModCavernousBiomes;
import com.mushroom.midnight.common.world.MidnightNoiseGenerator;
import com.mushroom.midnight.common.world.PartialChunkGenerator;
import com.mushroom.midnight.common.world.generator.WorldGenMidnightCaves;
import com.mushroom.midnight.common.world.generator.WorldGenMoltenCrater;
import com.mushroom.midnight.common.world.noise.OctaveNoiseSampler;
import com.mushroom.midnight.common.world.util.NoiseChunkPrimer;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class MidnightChunkGenerator
implements IChunkGenerator,
PartialChunkGenerator {
    private static final BiomeLayerSampler<CavernousBiome> DEFAULT_CAVERN_SAMPLER = new BiomeLayerSampler.Constant<CavernousBiome>(ModCavernousBiomes.CLOSED_CAVERN);
    public static final int SURFACE_LEVEL = 78;
    public static final int MIN_CAVE_HEIGHT = 20;
    public static final int MAX_CAVE_HEIGHT = 46;
    public static final int MIN_SURFACE_LEVEL = 58;
    private static final IBlockState STONE = ModBlocks.NIGHTSTONE.func_176223_P();
    private static final IBlockState WATER = ModBlocks.DARK_WATER.func_176223_P();
    private static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    private final World world;
    private final Random random;
    private Biome[] biomeBuffer;
    private final CavernousBiome[] cavernBiomeBuffer = new CavernousBiome[256];
    private Biome[] biomeNoiseBuffer;
    private final CavernousBiome[] cavernNoiseBuffer = new CavernousBiome[81];
    private final MidnightNoiseGenerator noiseGenerator;
    private final OctaveNoiseSampler depthNoise;
    private final double[] depthBuffer = new double[256];
    private final MapGenBase caveGenerator;
    private final MapGenBase craterGenerator;
    private final NoiseChunkPrimer noisePrimer;

    public MidnightChunkGenerator(World world) {
        this.world = world;
        this.random = new Random(world.func_72905_C());
        this.depthNoise = OctaveNoiseSampler.perlin(this.random, 4);
        this.depthNoise.setFrequency(0.0625);
        this.noiseGenerator = new MidnightNoiseGenerator(this.random);
        this.noisePrimer = new NoiseChunkPrimer(4, 4, 4, 64);
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)new WorldGenMidnightCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.craterGenerator = TerrainGen.getModdedMapGen((MapGenBase)new WorldGenMoltenCrater(this.random, this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CUSTOM);
        this.world.func_181544_b(80);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        this.primeChunk(primer, chunkX, chunkZ);
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)Biome.func_185362_a((Biome)this.biomeBuffer[i]);
        }
        CavernousBiomeStore cavernousBiomeStore = (CavernousBiomeStore)chunk.getCapability(Midnight.CAVERNOUS_BIOME_CAP, null);
        if (cavernousBiomeStore != null) {
            cavernousBiomeStore.populate(this.cavernBiomeBuffer);
        }
        chunk.func_76603_b();
        return chunk;
    }

    @Override
    public void primeChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
        this.primeChunkBare(primer, chunkX, chunkZ);
        int globalX = chunkX << 4;
        int globalZ = chunkZ << 4;
        BiomeProvider biomeProvider = this.world.func_72959_q();
        this.biomeBuffer = biomeProvider.func_76933_b(this.biomeBuffer, globalX, globalZ, 16, 16);
        this.getCavernousBiomeSampler().sample((CavernousBiome[])this.cavernBiomeBuffer, globalX, globalZ, 16, 16);
        this.coverSurface(primer, chunkX, chunkZ);
        this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.craterGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
    }

    @Override
    public void primeChunkBare(ChunkPrimer primer, int chunkX, int chunkZ) {
        int originX = chunkX * 4 - 2;
        int originZ = chunkZ * 4 - 2;
        this.biomeNoiseBuffer = this.world.func_72959_q().func_76937_a(this.biomeNoiseBuffer, originX, originZ, 9, 9);
        this.getCavernousBiomeSampler().sampleNoise((CavernousBiome[])this.cavernNoiseBuffer, originX, originZ, 9, 9);
        double[] terrainBuffer = this.noiseGenerator.populateNoise(chunkX, chunkZ, this.biomeNoiseBuffer, this.cavernNoiseBuffer);
        int seaLevel = this.world.func_181545_F();
        this.noisePrimer.primeChunk(primer, terrainBuffer, (density, x, y, z) -> {
            if (density > 0.0) {
                return STONE;
            }
            if (y < seaLevel && y > 58) {
                return WATER;
            }
            return null;
        });
    }

    private void coverSurface(ChunkPrimer primer, int chunkX, int chunkZ) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        int globalX = chunkX << 4;
        int globalZ = chunkZ << 4;
        this.depthNoise.sample2D(this.depthBuffer, globalX, globalZ, 16, 16);
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int index = localX + localZ * 16;
                Biome biome = this.biomeBuffer[index];
                CavernousBiome cavernousBiome = this.cavernBiomeBuffer[index];
                double depth = this.depthBuffer[index];
                for (int localY = 0; localY < 5; ++localY) {
                    if (localY > this.random.nextInt(5)) continue;
                    primer.func_177855_a(localX, localY, localZ, BEDROCK);
                }
                biome.func_180622_a(this.world, this.random, primer, globalZ + localZ, globalX + localX, depth);
                cavernousBiome.coverSurface(this.random, primer, globalX + localX, globalZ + localZ, depth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        try {
            MidnightWorldSpawners worldSpawners;
            int globalX = chunkX << 4;
            int globalZ = chunkZ << 4;
            BlockPos origin = new BlockPos(globalX, 0, globalZ);
            Biome biome = this.world.func_180494_b(origin.func_177982_a(16, 0, 16));
            CavernousBiome cavernousBiome = CavernousBiomeStore.getBiome(this.world, globalX + 16, globalZ + 16);
            this.random.setSeed(this.world.func_72905_C());
            long chunkSeedX = this.random.nextLong() / 2L * 2L + 1L;
            long chunkSeedZ = this.random.nextLong() / 2L * 2L + 1L;
            this.random.setSeed((long)chunkX * chunkSeedX + (long)chunkZ * chunkSeedZ ^ this.world.func_72905_C());
            ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false);
            biome.func_180624_a(this.world, this.random, origin);
            cavernousBiome.decorate(this.world, this.random, origin);
            if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS) && (worldSpawners = (MidnightWorldSpawners)this.world.getCapability(Midnight.WORLD_SPAWNERS_CAP, null)) != null) {
                worldSpawners.populateChunk(chunkX, chunkZ, this.random);
            }
            ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false);
        }
        finally {
            BlockFalling.field_149832_M = false;
        }
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        return false;
    }

    private BiomeLayerSampler<CavernousBiome> getCavernousBiomeSampler() {
        BiomeLayerSampler<CavernousBiome> layer;
        MultiLayerBiomeSampler multiLayerSampler = (MultiLayerBiomeSampler)this.world.getCapability(Midnight.MULTI_LAYER_BIOME_SAMPLER_CAP, null);
        if (multiLayerSampler != null && (layer = multiLayerSampler.getLayer(MidnightBiomeLayer.UNDERGROUND)) != null) {
            return layer;
        }
        return DEFAULT_CAVERN_SAMPLER;
    }
}

