/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.util;

import com.mushroom.midnight.common.entity.creature.EntityRifter;
import com.mushroom.midnight.common.entity.util.AttachmentSolver;
import com.mushroom.midnight.common.util.EntityUtil;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;

public class DragSolver {
    private final EntityRifter owner;
    private final AttachmentSolver attachmentSolver;
    private EntityLivingBase dragged;
    private Vector3d attachmentPoint;
    private Vector3d prevAttachmentPoint;

    public DragSolver(EntityRifter owner) {
        this.owner = owner;
        this.attachmentSolver = new AttachmentSolver((EntityLivingBase)this.owner);
    }

    public void setDragged(EntityLivingBase dragged) {
        if (this.dragged != null) {
            this.resetDragged(this.dragged);
        }
        this.dragged = dragged;
        if (dragged != null) {
            this.initDragged(dragged);
        }
    }

    private void initDragged(EntityLivingBase entity) {
        entity.field_70145_X = true;
    }

    private void resetDragged(EntityLivingBase entity) {
        entity.field_70145_X = false;
        entity.field_70159_w = entity.field_70165_t - entity.field_70169_q;
        entity.field_70181_x = entity.field_70163_u - entity.field_70167_r;
        entity.field_70179_y = entity.field_70161_v - entity.field_70166_s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solveDrag() {
        if (this.dragged == null) {
            this.attachmentPoint = null;
            return;
        }
        this.prevAttachmentPoint = this.attachmentPoint;
        float entityWidth = this.getTransformedWidth();
        float dragOffset = (this.owner.field_70130_N + entityWidth) / 2.0f + 0.2f;
        float theta = (float)Math.toRadians(this.owner.field_70761_aq);
        double dragOriginX = MathHelper.func_76126_a((float)theta) * dragOffset;
        double dragOriginZ = -MathHelper.func_76134_b((float)theta) * dragOffset;
        this.attachmentSolver.getAttachmentPoint().moveTo(dragOriginX, 0.0, dragOriginZ);
        this.solveRotation(this.dragged);
        this.dragged.field_70145_X = false;
        try {
            AttachmentSolver.Result result = this.attachmentSolver.solveAttachment(this.dragged);
            this.attachmentPoint = result.getSnappedPoint();
        }
        finally {
            this.dragged.field_70145_X = true;
            this.dragged.field_70179_y = 0.0;
            this.dragged.field_70181_x = 0.0;
            this.dragged.field_70159_w = 0.0;
        }
    }

    private float getTransformedWidth() {
        EntityUtil.Stance stance = EntityUtil.getStance(this.dragged);
        return stance == EntityUtil.Stance.QUADRUPEDAL ? this.dragged.field_70130_N : this.dragged.field_70131_O;
    }

    private void solveRotation(EntityLivingBase entity) {
        entity.func_181013_g(this.owner.field_70177_z);
        float deltaYaw = this.owner.field_70177_z - this.owner.field_70126_B;
        entity.field_70177_z += deltaYaw;
        entity.func_70034_d(entity.func_70079_am() + deltaYaw);
    }

    @Nullable
    public Vector3d getAttachmentPoint() {
        return this.attachmentPoint;
    }

    @Nullable
    public Vector3d lerpAttachmentPoint(float partialTicks) {
        if (this.attachmentPoint == null) {
            return null;
        }
        if (this.prevAttachmentPoint == null) {
            this.prevAttachmentPoint = this.attachmentPoint;
        }
        Vector3d lerp = new Vector3d();
        lerp.interpolate((Tuple3d)this.prevAttachmentPoint, (Tuple3d)this.attachmentPoint, (double)partialTicks);
        return lerp;
    }
}

