/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.AnimationCapability;
import com.mushroom.midnight.common.entity.NavigatorFlying;
import com.mushroom.midnight.common.entity.task.EntityTaskHunterIdle;
import com.mushroom.midnight.common.entity.task.EntityTaskHunterSwoop;
import com.mushroom.midnight.common.entity.task.EntityTaskHunterTarget;
import com.mushroom.midnight.common.entity.task.EntityTaskHunterTrack;
import com.mushroom.midnight.common.entity.util.ChainSolver;
import com.mushroom.midnight.common.registry.ModEffects;
import com.mushroom.midnight.common.registry.ModLootTables;
import com.mushroom.midnight.common.util.MeanValueRecorder;
import javax.annotation.Nullable;
import javax.vecmath.Point3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class EntityHunter
extends EntityMob
implements EntityFlying {
    private final AnimationCapability animCap = new AnimationCapability();
    public static final int FLIGHT_HEIGHT = 40;
    public float roll;
    public float prevRoll;
    public int swoopCooldown;
    private final MeanValueRecorder deltaYaw = new MeanValueRecorder(20);
    private final ChainSolver<EntityHunter> chainSolver = new ChainSolver<EntityHunter>(new Point3f(0.0f, 0.0f, 0.5875f), new Point3f[]{new Point3f(0.0f, 0.0f, 0.775f), new Point3f(0.0f, 0.0f, 1.65f), new Point3f(0.0f, 0.0f, 2.525f)}, 0.5f, 0.5f, (entity, matrix) -> {
        matrix.rotate(entity.field_70177_z, 0.0, 1.0, 0.0);
        matrix.rotate(entity.roll, 0.0, 0.0, 1.0);
        matrix.rotate(-entity.field_70125_A, 1.0, 0.0, 0.0);
    });

    public EntityHunter(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70765_h = new MoveHelper(this);
        this.field_70749_g = new LookHelper((EntityLiving)this);
    }

    protected PathNavigate func_175447_b(World world) {
        NavigatorFlying navigator = new NavigatorFlying((EntityLiving)this, world);
        navigator.func_192879_a(false);
        navigator.func_192877_c(false);
        navigator.func_192878_b(false);
        return navigator;
    }

    public boolean func_70601_bi() {
        return this.func_180425_c().func_177956_o() > this.field_70170_p.func_181545_F() && super.func_70601_bi();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.12);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityTaskHunterSwoop(this, 1.3));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityTaskHunterTrack(this, 0.7));
        this.field_70714_bg.func_75776_a(100, (EntityAIBase)new EntityTaskHunterIdle(this, 0.6));
        this.field_70715_bh.func_75776_a(1, new EntityTaskHunterTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class));
        this.field_70715_bh.func_75776_a(2, new EntityTaskHunterTarget<EntityAnimal>((EntityCreature)this, EntityAnimal.class));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.swoopCooldown > 0) {
                --this.swoopCooldown;
            }
        } else {
            this.deltaYaw.record(this.field_70177_z - this.field_70126_B);
            float deltaYaw = this.deltaYaw.computeMean();
            this.prevRoll = this.roll;
            this.roll = MathHelper.func_76131_a((float)(-deltaYaw * 8.0f), (float)-45.0f, (float)45.0f);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean grounded, IBlockState state, BlockPos pos) {
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() || this.func_184186_bw()) {
            double speed = (double)this.func_70689_ay() * 0.3;
            Vec3d lookVector = this.func_70040_Z();
            Vec3d moveVector = lookVector.func_72432_b().func_186678_a(speed);
            this.field_70159_w += moveVector.field_72450_a;
            this.field_70181_x += moveVector.field_72448_b;
            this.field_70179_y += moveVector.field_72449_c;
            this.field_70159_w *= 0.91;
            this.field_70181_x *= 0.91;
            this.field_70179_y *= 0.91;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.updateLimbs();
    }

    private void updateLimbs() {
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.field_70165_t - this.field_70169_q;
        double deltaY = this.field_70163_u - this.field_70167_r;
        double deltaZ = this.field_70161_v - this.field_70166_s;
        float distance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        float moveAmount = Math.min(distance * 4.0f, 1.0f);
        this.field_70721_aZ += (moveAmount - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)entity;
                float theta = (float)Math.toRadians(this.field_70177_z);
                living.func_70653_a((Entity)this, 0.3f, (double)MathHelper.func_76126_a((float)theta), (double)(-MathHelper.func_76134_b((float)theta)));
                living.func_70690_d(new PotionEffect(ModEffects.TORMENTED, 120));
                this.animCap.setAnimation((Entity)this, AnimationCapability.AnimationType.ATTACK, 10);
            }
            return true;
        }
        return false;
    }

    public ChainSolver<EntityHunter> getChainSolver() {
        return this.chainSolver;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.LOOT_TABLE_HUNTER;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.animCap.updateAnimation();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == Midnight.ANIMATION_CAP) {
            return (T)Midnight.ANIMATION_CAP.cast((Object)this.animCap);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Midnight.ANIMATION_CAP || super.hasCapability(capability, facing);
    }

    private static class LookHelper
    extends EntityLookHelper {
        private final EntityLiving parent;

        LookHelper(EntityLiving parent) {
            super(parent);
            this.parent = parent;
        }

        public void func_75649_a() {
            float deltaYaw = MathHelper.func_76142_g((float)(this.parent.field_70759_as - this.parent.field_70761_aq));
            if (!this.parent.func_70661_as().func_75500_f()) {
                if (deltaYaw < -75.0f) {
                    this.parent.field_70759_as = this.parent.field_70761_aq - 75.0f;
                }
                if (deltaYaw > 75.0f) {
                    this.parent.field_70759_as = this.parent.field_70761_aq + 75.0f;
                }
            }
        }
    }

    private static class MoveHelper
    extends EntityMoveHelper {
        private static final float CLOSE_TURN_SPEED = 150.0f;
        private static final float FAR_TURN_SPEED = 6.5f;
        private static final float CLOSE_TURN_DISTANCE = 2.0f;
        private static final float FAR_TURN_DISTANCE = 7.0f;

        MoveHelper(EntityHunter parent) {
            super((EntityLiving)parent);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                double deltaX = this.field_75646_b - this.field_75648_a.field_70165_t;
                double deltaY = this.field_75647_c - this.field_75648_a.field_70163_u;
                double deltaZ = this.field_75644_d - this.field_75648_a.field_70161_v;
                double distanceSquared = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                if (distanceSquared < 2.5) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float distance = MathHelper.func_76133_a((double)distanceSquared);
                float turnSpeed = this.computeTurnSpeed(distance);
                float targetYaw = (float)Math.toDegrees(MathHelper.func_181159_b((double)deltaZ, (double)deltaX)) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, targetYaw, turnSpeed);
                double deltaHorizontal = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                float targetPitch = (float)(-Math.toDegrees(Math.atan2(deltaY, deltaHorizontal)));
                this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, targetPitch, turnSpeed);
                double flySpeed = this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e();
                double resultSpeed = this.field_75645_e * flySpeed;
                this.field_75648_a.func_70659_e((float)resultSpeed);
            } else {
                this.field_75648_a.func_191989_p(0.0f);
            }
        }

        private float computeTurnSpeed(float distance) {
            float lerpRange = 5.0f;
            float alpha = MathHelper.func_76131_a((float)((distance - 2.0f) / lerpRange), (float)0.0f, (float)1.0f);
            float turnSpeed = 150.0f + -143.5f * alpha;
            return turnSpeed * (float)this.field_75645_e;
        }
    }
}

