/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="midnight", name="midnight")
@Config.LangKey(value="midnight.config.title")
@Mod.EventBusSubscriber(modid="midnight")
public class MidnightConfig {
    @Config.Name(value="general")
    @Config.LangKey(value="config_cat.midnight.general")
    @Config.Comment(value={"All the options that can only be set on the server."})
    public static CatGeneral general = new CatGeneral();
    @Config.Name(value="client")
    @Config.LangKey(value="config_cat.midnight.client")
    @Config.Comment(value={"All the options that can be modified by players on server."})
    public static CatClient client = new CatClient();

    @SubscribeEvent
    public static void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("midnight")) {
            ConfigManager.sync((String)"midnight", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class CatClient {
        @Config.Name(value="hide_vignette_effect")
        @Config.LangKey(value="config.midnight.hide_vignette_effect")
        @Config.Comment(value={"Hides the vignette effect in the darker areas of Midnight. Default= true"})
        public boolean hideVignetteEffect = true;
        @Config.Name(value="rift_shaders")
        @Config.LangKey(value="config.midnight.rift_shaders")
        @Config.Comment(value={"If true, rifts will be rendered with custom shaders for standard effects. If false, a simpler (motionless) texture will be rendered. Default= true"})
        public boolean riftShaders = true;
    }

    public static class CatGeneral {
        @Config.Name(value="midnight_dimension_id")
        @Config.LangKey(value="config.midnight.midnight_dimension_id")
        @Config.Comment(value={"The ID to be used for the Midnight Dimension. Default= -23"})
        @Config.RequiresMcRestart
        public int midnightDimensionId = -23;
        @Config.Name(value="bladeshroom_damage_chance")
        @Config.LangKey(value="config.midnight.bladeshroom_damage_chance")
        @Config.Comment(value={"The chance to take a small amount of damage when picking a bladeshroom cap as a percentage. If 0, this is disabled. Default= 5"})
        @Config.RangeInt(min=0, max=100)
        public int bladeshroomDamageChance = 5;
        @Config.Name(value="can_respawn_in_midnight")
        @Config.LangKey(value="config.midnight.can_respawn_in_midnight")
        @Config.Comment(value={"If true, players will respawn in Midnight after dying in the dimension. Default= false"})
        public boolean canRespawnInMidnight = false;
        @Config.Name(value="allow_lightning_damage")
        @Config.LangKey(value="config.midnight.allow_lightning_damage")
        @Config.Comment(value={"Allows the lightning in Midnight to burn blocks and do damage to entities. Default= false"})
        public boolean allowLightningDamage = false;
        @Config.Name(value="rift_spawn_rarity")
        @Config.LangKey(value="config.midnight.rift_spawn_rarity")
        @Config.Comment(value={"The rarity that a rift appears. Larger numbers increase rarity. If 0, rifts don't spawn. Default= 1000"})
        @Config.RangeInt(min=0, max=10000)
        public int riftSpawnRarity = 1000;
        @Config.Name(value="rifter_spawn_rarity")
        @Config.LangKey(value="config.midnight.rifter_spawn_rarity")
        @Config.Comment(value={"The rarity that rifts spawn rifters. Larger numbers increase rarity. If 0, rifters don't spawn. Default= 1000"})
        @Config.RangeInt(min=0, max=10000)
        public int rifterSpawnRarity = 1000;
        @Config.Name(value="max_rifter_by_rift")
        @Config.LangKey(value="config.midnight.max_rifter_by_rift")
        @Config.Comment(value={"The maximum amount of rifters that spawn from a rift. Default= 1"})
        @Config.RangeInt(min=1, max=5)
        public int maxRifterByRift = 1;
        @Config.Name(value="allow_rifter_teleport")
        @Config.LangKey(value="config.midnight.allow_rifter_teleport")
        @Config.Comment(value={"Allows rifters to teleport to players when they aren't being looked at. Default= true"})
        public boolean allowRifterTeleport = true;
        @Config.Name(value="monster_spawn_rate")
        @Config.LangKey(value="config.midnight.monster_spawn_rate")
        @Config.Comment(value={"Spawn rate of entities of the 'monster' type in midnight (eg. Rifter, Hunter). Default= 1"})
        @Config.RangeInt(min=1)
        public int monsterSpawnRate = 1;
        @Config.Name(value="rifter_capture_tamed_animal")
        @Config.LangKey(value="config.midnight.rifter_capture_tamed_animal")
        @Config.Comment(value={"Allows rifters to capture tamed entities and drag them into rifts. Default= false"})
        public boolean rifterCaptureTamedAnimal = false;
        @Config.Name(value="capturable_entities")
        @Config.RequiresWorldRestart
        @Config.LangKey(value="config.midnight.capturable_entities")
        @Config.Comment(value={"Mobs on this whitelist can be captured by rifters, players and animals are already captured by default. Format is mod id:name of creature, just use the modid to whitelist everything from it. Default= empty"})
        public String[] capturableEntities = new String[0];
        @Config.Name(value="not_capturable_animals")
        @Config.RequiresWorldRestart
        @Config.LangKey(value="config.midnight.not_capturable_animals")
        @Config.Comment(value={"Mobs on this blacklist cannot be captured by rifters. Format is mod id:name of creature, just use the mod id to blacklist everything from it. Default= iceandfire, midnight:nightstag"})
        public String[] notCapturableAnimals = new String[]{"iceandfire", "midnight:nightstag"};
        @Config.Name(value="foreign_flowers_from_bonemeal")
        @Config.LangKey(value="config.midnight.foreign_flowers_from_bonemeal")
        @Config.Comment(value={"Allows the modded flowers to appear with bonemeal in Midnight. Default= false"})
        public boolean foreignFlowersFromBonemeal = false;
    }
}

