/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.client.particle.MidnightParticles;
import com.mushroom.midnight.common.network.MessageRockshroomBroken;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.registry.ModItems;
import com.mushroom.midnight.common.registry.ModTabs;
import com.mushroom.midnight.common.util.MidnightDamageSource;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockRockshroom
extends Block
implements IModelProvider {
    private static final int SPORE_COUNT = 32;
    private static final double SPORE_SPEED = 0.3;
    private static final double DAMAGE_RANGE = 4.0;
    private static final DamageSource ROCKSHROOM_SPORE = new MidnightDamageSource("rockshroom_spore");

    public BlockRockshroom() {
        super(Material.field_151576_e, MapColor.field_193567_S);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(ModTabs.BUILDING_TAB);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        boolean result = super.removedByPlayer(state, world, pos, player, willHarvest);
        this.onBroken(world, pos, player);
        return result;
    }

    private void onBroken(World world, BlockPos pos, EntityPlayer player) {
        ItemStack heldItem = player.func_184614_ca();
        if (player.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)heldItem) > 0) {
            return;
        }
        if (!world.field_72995_K) {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0);
            Midnight.NETWORK.sendToAllTracking((IMessage)new MessageRockshroomBroken(pos), point);
            this.damagePlayer(world, pos, player);
        }
    }

    private void damagePlayer(World world, BlockPos pos, EntityPlayer player) {
        Vec3d origin = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        Vec3d target = player.func_174824_e(1.0f);
        if (target.func_178788_d(origin).func_189985_c() > 16.0) {
            return;
        }
        RayTraceResult rayTrace = world.func_72933_a(origin, target);
        if (rayTrace == null || rayTrace.field_72313_a == RayTraceResult.Type.MISS) {
            player.func_70097_a(ROCKSHROOM_SPORE, world.field_73012_v.nextFloat() * 3.5f + 0.5f);
        }
    }

    public void spawnSpores(World world, BlockPos pos) {
        Random random = world.field_73012_v;
        for (int i = 0; i < 32; ++i) {
            Vec3d direction = new Vec3d((double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f)).func_72432_b();
            double x = (double)pos.func_177958_n() + 0.5 + direction.field_72450_a * 0.4;
            double y = (double)pos.func_177956_o() + 0.5 + direction.field_72448_b * 0.4;
            double z = (double)pos.func_177952_p() + 0.5 + direction.field_72449_c * 0.4;
            Vec3d vel = direction.func_186678_a(0.3);
            MidnightParticles.SPORE.spawn(world, x, y, z, vel.field_72450_a, vel.field_72448_b + 0.05, vel.field_72449_c, new int[0]);
        }
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(ModBlocks.ROCKSHROOM);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.ROCKSHROOM_CLUMP;
    }

    public int func_149679_a(int fortune, Random random) {
        return this.func_149745_a(random) + random.nextInt(fortune + 1);
    }

    public int func_149745_a(Random random) {
        return random.nextInt(2) + 2;
    }
}

