/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.particle;

import com.mushroom.midnight.client.particle.MidnightParticleSprites;
import com.mushroom.midnight.common.block.BlockSporch;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SporchParticle
extends Particle {
    private final float flameScale;
    private final List<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>();
    private final int MAX_FRAME_ID = 2;
    private int currentFrame = 0;
    private boolean directionRight = true;
    private int lastTick = 0;

    public SporchParticle(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ, int sporchType) {
        super(world, posX, posY, posZ, motionX, motionY, motionZ);
        this.field_187129_i = this.field_187129_i * (double)0.01f + motionX;
        this.field_187130_j = this.field_187130_j * (double)0.01f + motionY;
        this.field_187131_k = this.field_187131_k * (double)0.01f + motionZ;
        this.field_187126_f += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187127_g += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187128_h += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_70544_f = 1.3f;
        this.flameScale = 1.3f;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.initTextures(BlockSporch.SporchType.values()[Math.min(sporchType, BlockSporch.SporchType.values().length)]);
        this.func_187117_a(this.sprites.get(0));
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (entity.field_70173_aa >= this.lastTick + 5) {
            this.func_187117_a(this.sprites.get(this.currentFrame));
            if (this.currentFrame == 2) {
                this.directionRight = false;
            } else if (this.currentFrame == 0) {
                this.directionRight = true;
            }
            this.currentFrame += this.directionRight ? 1 : -1;
            this.lastTick = entity.field_70173_aa;
        }
        float f = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_70544_f = this.flameScale * (1.0f - f * f * 0.5f);
        super.func_180434_a(buffer, entity, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public int func_189214_a(float partialTick) {
        float f = ((float)this.field_70546_d + partialTick) / (float)this.field_70547_e;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_189214_a(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    private void initTextures(BlockSporch.SporchType sporchType) {
        switch (sporchType) {
            case BOGSHROOM: {
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_BOGSHROOM_1));
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_BOGSHROOM_2));
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_BOGSHROOM_3));
                break;
            }
            case DEWSHROOM: {
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_DEWSHROOM_1));
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_DEWSHROOM_2));
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_DEWSHROOM_3));
                break;
            }
            case NIGHTSHROOM: {
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_NIGHTSHROOM_1));
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_NIGHTSHROOM_2));
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_NIGHTSHROOM_3));
                break;
            }
            default: {
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_VIRIDSHROOM_1));
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_VIRIDSHROOM_2));
                this.sprites.add(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORCH_VIRIDSHROOM_3));
            }
        }
    }

    public int func_70537_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ, int ... params) {
            return new SporchParticle(world, posX, posY, posZ, motionX, motionY, motionZ, params.length > 0 ? params[0] : world.field_73012_v.nextInt(BlockSporch.SporchType.values().length));
        }
    }
}

