/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client;

import com.mushroom.midnight.common.block.BlockDarkWater;
import com.mushroom.midnight.common.block.BlockMiasmaFluid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="midnight", value={Side.CLIENT})
public class FluidImmersionRenderer {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final ResourceLocation DARK_WATER_OVERLAY = new ResourceLocation("midnight", "textures/effects/dark_water_overlay.png");
    public static IBlockState immersedState = Blocks.field_150350_a.func_176223_P();

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && FluidImmersionRenderer.MC.field_71439_g != null) {
            immersedState = ActiveRenderInfo.func_186703_a((World)FluidImmersionRenderer.MC.field_71441_e, (Entity)FluidImmersionRenderer.MC.field_71439_g, (float)event.renderTickTime);
        }
    }

    @SubscribeEvent
    public static void onSetupFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (immersedState.func_177230_c() instanceof BlockMiasmaFluid) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            event.setDensity(2.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        if (immersedState.func_177230_c() instanceof BlockDarkWater) {
            FluidImmersionRenderer.renderOverlay(DARK_WATER_OVERLAY);
            event.setCanceled(true);
        }
    }

    private static void renderOverlay(ResourceLocation texture) {
        MC.func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        float brightness = FluidImmersionRenderer.MC.field_71439_g.func_70013_c();
        GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)0.5f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float scrollX = -FluidImmersionRenderer.MC.field_71439_g.field_70177_z / 64.0f;
        float scrollY = FluidImmersionRenderer.MC.field_71439_g.field_70125_A / 64.0f;
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + scrollX), (double)(4.0f + scrollY)).func_181675_d();
        builder.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)scrollX, (double)(4.0f + scrollY)).func_181675_d();
        builder.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)scrollX, (double)scrollY).func_181675_d();
        builder.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + scrollX), (double)scrollY).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

