/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.subterraneanwaters;

import com.kreezcraft.subterraneanwaters.ModConfig;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import org.apache.commons.lang3.ArrayUtils;

public class ModGenerator {
    private static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private boolean initialized = false;
    private Random random;
    private NoiseGeneratorOctaves noiseGenStone1;
    private NoiseGeneratorOctaves noiseGenStone2;
    private NoiseGeneratorOctaves noiseGenStoneMask;
    private NoiseGeneratorOctaves noiseGenStoneMask2;
    private double[] tempArrayStone1;
    private double[] tempArrayStone2;
    private double[] tempArrayStoneMask;
    private double[] tempArrayStoneMask2;
    private double[] tempArrayStone;
    static ModConfig.OceanConfig config;

    public void generate(ChunkPrimer primer, World world, Random random, int chunkX, int chunkZ, IChunkGenerator generator) {
        if (ArrayUtils.contains((int[])ModConfig.dimensions, (int)world.field_73011_w.getDimension())) {
            config = ModConfig.map.get(world.field_73011_w.getDimension());
            if (!this.initialized) {
                this.random = new Random(world.func_72905_C());
                this.noiseGenStone1 = new NoiseGeneratorOctaves(this.random, 16);
                this.noiseGenStone2 = new NoiseGeneratorOctaves(this.random, 16);
                this.noiseGenStoneMask = new NoiseGeneratorOctaves(this.random, 8);
                this.noiseGenStoneMask2 = new NoiseGeneratorOctaves(this.random, 8);
                this.tempArrayStone = new double[297];
                this.initialized = true;
            }
            this.doGenerate(chunkX, chunkZ, primer);
        }
    }

    private void initNoise(int shiftX, int shiftY, int shiftZ, int sizeX, int sizeY, int sizeZ) {
        double noiseScaleHorisontal = 1368.824;
        double noiseScaleVertical = 684.412;
        this.tempArrayStoneMask = this.noiseGenStoneMask.func_76304_a(this.tempArrayStoneMask, shiftX, shiftY, shiftZ, sizeX, sizeY, sizeZ, noiseScaleHorisontal / 80.0, noiseScaleVertical / 160.0, noiseScaleHorisontal / 80.0);
        this.tempArrayStoneMask2 = this.noiseGenStoneMask2.func_76304_a(this.tempArrayStoneMask2, shiftX, shiftY, shiftZ, sizeX, sizeY, sizeZ, noiseScaleHorisontal / 80.0, noiseScaleVertical / 160.0, noiseScaleHorisontal / 80.0);
        this.tempArrayStone1 = this.noiseGenStone1.func_76304_a(this.tempArrayStone1, shiftX, shiftY, shiftZ, sizeX, sizeY, sizeZ, noiseScaleHorisontal / 2.0, noiseScaleVertical / 2.0, noiseScaleHorisontal / 2.0);
        this.tempArrayStone2 = this.noiseGenStone2.func_76304_a(this.tempArrayStone2, shiftX, shiftY, shiftZ, sizeX, sizeY, sizeZ, noiseScaleHorisontal / 2.0, noiseScaleVertical / 2.0, noiseScaleHorisontal / 2.0);
        int k = 0;
        for (int posX = 0; posX < sizeX; ++posX) {
            for (int posZ = 0; posZ < sizeZ; ++posZ) {
                for (int posY = 0; posY < sizeY; ++posY) {
                    double noiseValue1 = this.tempArrayStone1[k] / 512.0;
                    double noiseValue2 = this.tempArrayStone2[k] / 512.0;
                    double noiseValueMask = (this.tempArrayStoneMask[k] / 10.0 + 1.0) / 2.0;
                    double noiseValueMask2 = (this.tempArrayStoneMask2[k] / 10.0 + 1.0) / 2.0;
                    this.tempArrayStone[k] = ModGenerator.calculateNoiseValue(posY, noiseValue1, noiseValue2, noiseValueMask) - (double)(3.0f * MathHelper.func_76126_a((float)((float)posY / 1.5f)));
                    this.tempArrayStone[k] = ModGenerator.interpolateLinear(this.tempArrayStone[k], -3.0, noiseValueMask2);
                    ++k;
                }
            }
        }
    }

    private static double calculateNoiseValue(int posY, double noiseValue1, double noiseValue2, double noiseValueMask) {
        double heightOverhead;
        double noiseValue = ModGenerator.interpolateLinear(noiseValue1, noiseValue2, noiseValueMask) + (double)ModGenerator.config.noiseSummand;
        if (posY > ModGenerator.config.highLimit) {
            heightOverhead = ((double)posY - (double)ModGenerator.config.highLimit) / (double)ModGenerator.config.highOverheadLimit;
            noiseValue = noiseValue * (1.0 - heightOverhead) + -100.0 * heightOverhead;
        }
        if (posY < ModGenerator.config.lowLimit) {
            heightOverhead = ((double)ModGenerator.config.lowLimit - (double)posY) / (double)ModGenerator.config.lowOverheadLimit;
            noiseValue = noiseValue * (1.0 - heightOverhead) + -30.0 * heightOverhead;
        }
        return noiseValue;
    }

    private static double interpolateLinear(double value1, double value2, double k) {
        return value1 + (value2 - value1) * MathHelper.func_151237_a((double)k, (double)0.0, (double)1.0);
    }

    private void doGenerate(int x, int z, ChunkPrimer primer) {
        this.initNoise(x * 2, 0, z * 2, 3, 33, 3);
        for (int sampleX = 0; sampleX < 2; ++sampleX) {
            for (int sampleZ = 0; sampleZ < 2; ++sampleZ) {
                for (int sampleY = 0; sampleY < 25; ++sampleY) {
                    double bottomNearLeft = this.tempArrayStone[((sampleX + 0) * 3 + sampleZ + 0) * 33 + sampleY + 0];
                    double bottomNearRight = this.tempArrayStone[((sampleX + 0) * 3 + sampleZ + 1) * 33 + sampleY + 0];
                    double bottomFarLeft = this.tempArrayStone[((sampleX + 1) * 3 + sampleZ + 0) * 33 + sampleY + 0];
                    double bottomFarRight = this.tempArrayStone[((sampleX + 1) * 3 + sampleZ + 1) * 33 + sampleY + 0];
                    double topNearLeft = this.tempArrayStone[((sampleX + 0) * 3 + sampleZ + 0) * 33 + sampleY + 1];
                    double topNearRight = this.tempArrayStone[((sampleX + 0) * 3 + sampleZ + 1) * 33 + sampleY + 1];
                    double topFarLeft = this.tempArrayStone[((sampleX + 1) * 3 + sampleZ + 0) * 33 + sampleY + 1];
                    double topFarRight = this.tempArrayStone[((sampleX + 1) * 3 + sampleZ + 1) * 33 + sampleY + 1];
                    double dNearLeft = (topNearLeft - bottomNearLeft) / 4.0;
                    double dNearRight = (topNearRight - bottomNearRight) / 4.0;
                    double dFarLeft = (topFarLeft - bottomFarLeft) / 4.0;
                    double dFarRight = (topFarRight - bottomFarRight) / 4.0;
                    for (int shiftY = 0; shiftY < 4; ++shiftY) {
                        double currentLeft = bottomNearLeft;
                        double currentRight = bottomNearRight;
                        double dXLeft = (bottomFarLeft - bottomNearLeft) / 8.0;
                        double dXRight = (bottomFarRight - bottomNearRight) / 8.0;
                        for (int shiftX = 0; shiftX < 8; ++shiftX) {
                            double currentValue = currentLeft;
                            double dZ = (currentRight - currentLeft) / 16.0;
                            for (int shiftZ = 0; shiftZ < 8; ++shiftZ) {
                                if (currentValue > 0.0) {
                                    int worldX = shiftX + sampleX * 8;
                                    int worldY = shiftY + sampleY * 4;
                                    int worldZ = shiftZ + sampleZ * 8;
                                    IBlockState block = worldY > ModGenerator.config.liquidLevel ? AIR : WATER;
                                    primer.func_177855_a(worldX, worldY, worldZ, block);
                                }
                                currentValue += dZ;
                            }
                            currentLeft += dXLeft;
                            currentRight += dXRight;
                        }
                        bottomNearLeft += dNearLeft;
                        bottomNearRight += dNearRight;
                        bottomFarLeft += dFarLeft;
                        bottomFarRight += dFarRight;
                    }
                }
            }
        }
    }
}

