/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.config;

import com.mushroom.midnight.common.world.SurfacePlacementLevel;
import com.mushroom.midnight.common.world.feature.config.IPlacementConfig;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ParcelPlacementConfig
implements IPlacementConfig {
    private final int minCount;
    private final int maxCount;
    private final float chance;

    public ParcelPlacementConfig(int minCount, int maxCount, float chance) {
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.chance = chance;
    }

    @Override
    public void apply(World world, SurfacePlacementLevel placementLevel, Random random, BlockPos chunkOrigin, Consumer<BlockPos> generator) {
        int offsetZ;
        if (random.nextFloat() > this.chance) {
            return;
        }
        int offsetX = random.nextInt(16) + 8;
        BlockPos pos = chunkOrigin.func_177982_a(offsetX, 0, offsetZ = random.nextInt(16) + 8);
        int maxY = placementLevel.getSurfacePos(world, pos).func_177956_o() + 32;
        if (maxY > 0) {
            this.placeParcel(world, random, pos.func_177981_b(placementLevel.generateUpTo(world, random, maxY)), generator);
        }
    }

    private void placeParcel(World world, Random random, BlockPos pos, Consumer<BlockPos> generator) {
        IBlockState state;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos);
        while (mutablePos.func_177956_o() > 0 && ((state = world.func_180495_p((BlockPos)mutablePos)).func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)mutablePos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)mutablePos))) {
            mutablePos.func_189536_c(EnumFacing.DOWN);
        }
        pos = mutablePos.func_185334_h();
        int count = this.minCount;
        if (this.minCount != this.maxCount) {
            count = random.nextInt(this.maxCount - this.minCount + 1) + this.minCount;
        }
        for (int i = 0; i < count; ++i) {
            boolean isValid;
            int offsetX = random.nextInt(8) - random.nextInt(8);
            int offsetZ = random.nextInt(8) - random.nextInt(8);
            mutablePos.func_181079_c(pos.func_177958_n() + offsetX, Math.max(1, pos.func_177956_o() - 1), pos.func_177952_p() + offsetZ);
            while ((isValid = mutablePos.func_177956_o() <= pos.func_177956_o() + 1) && !world.func_175623_d((BlockPos)mutablePos)) {
                mutablePos.func_189536_c(EnumFacing.UP);
            }
            if (!isValid) continue;
            generator.accept(mutablePos.func_185334_h());
        }
    }
}

