/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.world.feature.TemplateTreeFeature;
import com.mushroom.midnight.common.world.template.ShelfAttachProcessor;
import com.mushroom.midnight.common.world.template.TemplateCompiler;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LargeBogshroomFeature
extends TemplateTreeFeature {
    private static final ResourceLocation[] TEMPLATES = new ResourceLocation[]{new ResourceLocation("midnight", "mushroom/bogshroom")};

    public LargeBogshroomFeature(IBlockState log, IBlockState leaves) {
        super(TEMPLATES, log, leaves);
    }

    public LargeBogshroomFeature() {
        this(ModBlocks.BOGSHROOM_STEM.func_176223_P(), ModBlocks.BOGSHROOM_HAT.func_176223_P());
    }

    @Override
    protected TemplateCompiler buildCompiler(ResourceLocation[] templates) {
        return super.buildCompiler(templates).withPostProcessor(new ShelfAttachProcessor(this::canPlaceShelf, ShelfAttachProcessor.SHELF_BLOCKS));
    }

    @Override
    protected void processData(World world, BlockPos pos, String key) {
        if (key.equals("inside")) {
            world.func_180501_a(pos, ModBlocks.MUSHROOM_INSIDE.func_176223_P(), 18);
        }
        super.processData(world, pos, key);
    }

    private boolean canPlaceShelf(World world, BlockPos pos) {
        if (world.func_189509_E(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == ModBlocks.MUSHROOM_INSIDE) {
            return false;
        }
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_185904_a() == Material.field_151582_l;
    }
}

