/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.RiftTravelCooldown;
import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.entity.RiftBridge;
import com.mushroom.midnight.common.registry.ModArmorMaterials;
import com.mushroom.midnight.common.util.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class MidnightTeleporter
implements ITeleporter {
    public static final int COOLDOWN = 40;
    private final EntityRift originRift;

    public MidnightTeleporter(EntityRift originRift) {
        this.originRift = originRift;
    }

    public void placeEntity(World world, Entity entity, float yaw) {
        EntityRift endpointRift;
        RiftBridge bridge = this.originRift.getBridge();
        if (bridge == null) {
            Midnight.LOGGER.warn("Unable to teleport entity through rift! Bridge not present on portal {}", (Object)this.originRift);
            return;
        }
        if (entity instanceof EntityPlayer && !EntityUtil.isCoveredBy((EntityLivingBase)entity, ModArmorMaterials.TENEBRUM)) {
            bridge.close();
        }
        if ((endpointRift = bridge.computeEndpoint(world.field_73011_w.func_186058_p())) == null) {
            Midnight.LOGGER.warn("Unable to teleport entity through rift! Endpoint not present from portal {}", (Object)this.originRift);
            return;
        }
        Vec3d placementPos = this.findPlacementPos(world, entity, endpointRift);
        entity.field_70165_t = placementPos.field_72450_a + 0.5;
        entity.field_70163_u = placementPos.field_72448_b + 0.5;
        entity.field_70161_v = placementPos.field_72449_c + 0.5;
        entity.field_70143_R = 0.0f;
        RiftTravelCooldown capability = (RiftTravelCooldown)entity.getCapability(Midnight.RIFT_TRAVEL_COOLDOWN_CAP, null);
        if (capability != null) {
            capability.setCooldown(40);
        }
    }

    private Vec3d findPlacementPos(World world, Entity entity, EntityRift endpointRift) {
        float displacementZ;
        float angle = (float)Math.toRadians(entity.field_70177_z);
        float displacementX = -MathHelper.func_76126_a((float)angle) * endpointRift.field_70130_N / 2.0f;
        Vec3d placementPos = new Vec3d(endpointRift.field_70165_t + (double)displacementX, endpointRift.field_70163_u + 0.5, endpointRift.field_70161_v + (double)(displacementZ = MathHelper.func_76134_b((float)angle) * endpointRift.field_70130_N / 2.0f));
        if (!world.func_184143_b(this.getEntityBoundAt(entity, placementPos))) {
            return placementPos;
        }
        BlockPos placementBlockPos = new BlockPos(placementPos.field_72450_a, placementPos.field_72448_b, placementPos.field_72449_c);
        BlockPos minPos = placementBlockPos.func_177982_a(-2, -2, -2);
        BlockPos maxPos = placementBlockPos.func_177982_a(2, 2, 2);
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)minPos, (BlockPos)maxPos)) {
            Vec3d originPos = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            AxisAlignedBB entityBound = this.getEntityBoundAt(entity, originPos);
            if (entityBound.func_72326_a(endpointRift.func_174813_aQ()) || world.func_184143_b(entityBound)) continue;
            return originPos;
        }
        BlockPos surface = world.func_175672_r(placementBlockPos);
        return new Vec3d(placementPos.field_72450_a, (double)surface.func_177956_o(), placementPos.field_72449_c);
    }

    private AxisAlignedBB getEntityBoundAt(Entity entity, Vec3d pos) {
        float halfWidth = entity.field_70130_N / 2.0f;
        return new AxisAlignedBB(pos.field_72450_a - (double)halfWidth, pos.field_72448_b, pos.field_72449_c - (double)halfWidth, pos.field_72450_a + (double)halfWidth, pos.field_72448_b + (double)entity.field_70131_O, pos.field_72449_c + (double)halfWidth);
    }
}

