/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.registry;

import com.mushroom.midnight.common.biome.MidnightBiomeConfigs;
import com.mushroom.midnight.common.biome.MidnightBiomeGroup;
import com.mushroom.midnight.common.biome.cavern.CavernStructureConfig;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.biome.cavern.CavernousBiomeConfig;
import com.mushroom.midnight.common.biome.config.BiomeSpawnEntry;
import com.mushroom.midnight.common.registry.RegUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="midnight")
@GameRegistry.ObjectHolder(value="midnight")
public class ModCavernousBiomes {
    private static final CavernStructureConfig CLOSED_STRUCTURE_CONFIG = new CavernStructureConfig().withCavernDensity(5.0f);
    public static final CavernousBiome CLOSED_CAVERN;
    public static final CavernousBiome GREAT_CAVERN;
    public static final CavernousBiome CRYSTAL_CAVERN;
    public static final CavernousBiome FUNGAL_CAVERN;
    private static ForgeRegistry<CavernousBiome> registry;

    @SubscribeEvent
    public static void onNewRegistry(RegistryEvent.NewRegistry event) {
        registry = (ForgeRegistry)new RegistryBuilder().setType(CavernousBiome.class).setName(new ResourceLocation("midnight", "cavernous_biomes")).setDefaultKey(new ResourceLocation("midnight", "closed_cavern")).create();
    }

    @SubscribeEvent
    public static void onRegisterBiomes(RegistryEvent.Register<CavernousBiome> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new CavernousBiome[]{RegUtil.withName(CLOSED_CAVERN, "closed_cavern"), RegUtil.withName(new CavernousBiome(MidnightBiomeConfigs.GREAT_CAVERN_CONFIG), "great_cavern"), RegUtil.withName(new CavernousBiome(MidnightBiomeConfigs.CRYSTAL_CAVERN_CONFIG), "crystal_cavern"), RegUtil.withName(new CavernousBiome(MidnightBiomeConfigs.FUNGAL_CAVERN_CONFIG), "fungal_cavern")});
    }

    public static void onInit() {
        MidnightBiomeGroup.UNDERGROUND.add(new BiomeSpawnEntry.Basic(GREAT_CAVERN, 100));
        MidnightBiomeGroup.UNDERGROUND_POCKET.add(new BiomeSpawnEntry.Basic(CRYSTAL_CAVERN, 10).canReplace(GREAT_CAVERN));
    }

    public static ForgeRegistry<CavernousBiome> getRegistry() {
        if (registry == null) {
            throw new IllegalStateException("Registry not yet initialized");
        }
        return registry;
    }

    public static int getId(CavernousBiome biome) {
        return registry.getID((IForgeRegistryEntry)biome);
    }

    public static CavernousBiome fromId(int id) {
        return (CavernousBiome)registry.getValue(id);
    }

    static {
        GREAT_CAVERN = CLOSED_CAVERN = new CavernousBiome(CavernousBiomeConfig.builder().withStructure(CLOSED_STRUCTURE_CONFIG).build());
        CRYSTAL_CAVERN = CLOSED_CAVERN;
        FUNGAL_CAVERN = CLOSED_CAVERN;
    }
}

